/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.stereotype.Component;

@Component(value="kafkaMgmtService")
public class KafkaConfigService
extends BasicService {
    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<KafkaConfig> listAllKafkaConfigs(String kafkaConfigName) throws IOException {
        ArrayList<KafkaConfig> kafkaConfigs = new ArrayList();
        if (null == kafkaConfigName) {
            kafkaConfigs = this.getKafkaManager().listAllKafkaConfigs();
        } else {
            List configs = this.getKafkaManager().listAllKafkaConfigs();
            for (KafkaConfig config : configs) {
                if (!kafkaConfigName.equals(config.getName())) continue;
                kafkaConfigs.add(config);
            }
        }
        return kafkaConfigs;
    }

    public List<KafkaConfig> getKafkaConfigs(String kafkaConfigName, Integer limit, Integer offset) throws IOException {
        List<KafkaConfig> kafkaConfigs = this.listAllKafkaConfigs(kafkaConfigName);
        if (limit == null || offset == null) {
            return kafkaConfigs;
        }
        if (kafkaConfigs.size() - offset < limit) {
            return kafkaConfigs.subList(offset, kafkaConfigs.size());
        }
        return kafkaConfigs.subList(offset, offset + limit);
    }

    public KafkaConfig createKafkaConfig(KafkaConfig config) throws IOException {
        if (this.getKafkaManager().getKafkaConfig(config.getName()) != null) {
            throw new InternalErrorException("The kafkaConfig named " + config.getName() + " already exists");
        }
        this.getKafkaManager().createKafkaConfig(config.getName(), config);
        return config;
    }

    public KafkaConfig updateKafkaConfig(KafkaConfig config) throws IOException {
        return this.getKafkaManager().updateKafkaConfig(config);
    }

    public KafkaConfig getKafkaConfig(String configName) throws IOException {
        return this.getKafkaManager().getKafkaConfig(configName);
    }

    public void dropKafkaConfig(KafkaConfig config) throws IOException {
        this.getKafkaManager().removeKafkaConfig(config);
    }
}

