/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.tool.HybridCubeCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="hybridService")
public class HybridService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(HybridService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_MODELER')")
    public HybridInstance createHybridCube(String hybridName, String projectName, String modelName, String[] cubeNames) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, (String)","));
        args.add("-action");
        args.add("create");
        try {
            HybridCubeCLI.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Create Hybrid Failed", (Throwable)e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public HybridInstance updateHybridCube(String hybridName, String projectName, String modelName, String[] cubeNames) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, (String)","));
        args.add("-action");
        args.add("update");
        try {
            HybridCubeCLI.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Update Hybrid Failed", (Throwable)e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public void deleteHybridCube(String hybridName, String projectName, String modelName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-action");
        args.add("delete");
        try {
            HybridCubeCLI.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Delete Hybrid Failed", (Throwable)e);
            throw e;
        }
    }

    public HybridInstance getHybridInstance(String hybridName) {
        HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(hybridName);
        return hybridInstance;
    }

    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<HybridInstance> listHybrids(String projectName, String modelName) {
        DataModelDesc model;
        ProjectInstance project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        ArrayList<HybridInstance> hybridsInProject = new ArrayList<HybridInstance>();
        if (StringUtils.isEmpty((String)projectName)) {
            hybridsInProject = new ArrayList(this.getHybridManager().listHybridInstances());
        } else {
            if (project == null) {
                return new ArrayList<HybridInstance>();
            }
            List realizationEntries = project.getRealizationEntries(RealizationType.HYBRID);
            if (realizationEntries != null) {
                for (RealizationEntry entry : realizationEntries) {
                    HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                    hybridsInProject.add(instance);
                }
            }
        }
        DataModelDesc dataModelDesc = model = null != modelName ? this.getMetadataManager().getDataModelDesc(modelName) : null;
        if (StringUtils.isEmpty((String)modelName)) {
            return hybridsInProject;
        }
        if (model == null) {
            return new ArrayList<HybridInstance>();
        }
        ArrayList<HybridInstance> hybridsInModel = new ArrayList<HybridInstance>();
        for (HybridInstance hybridInstance : hybridsInProject) {
            boolean hybridInModel = false;
            for (RealizationEntry entry : hybridInstance.getRealizationEntries()) {
                CubeDesc cubeDesc = this.getCubeDescManager().getCubeDesc(entry.getRealization());
                if (cubeDesc == null || !model.getName().equalsIgnoreCase(cubeDesc.getModel().getName())) continue;
                hybridInModel = true;
                break;
            }
            if (!hybridInModel) continue;
            hybridsInModel.add(hybridInstance);
        }
        return hybridsInModel;
    }
}

