/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="extFilterService")
public class ExtFilterService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ExtFilterService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void saveExternalFilter(ExternalFilterDesc desc) throws IOException {
        if (this.getMetadataManager().getExtFilterDesc(desc.getName()) != null) {
            throw new InternalErrorException("The filter named " + desc.getName() + " already exists");
        }
        this.getMetadataManager().saveExternalFilter(desc);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateExternalFilter(ExternalFilterDesc desc) throws IOException {
        if (this.getMetadataManager().getExtFilterDesc(desc.getName()) == null) {
            throw new InternalErrorException("The filter named " + desc.getName() + " does not exists");
        }
        this.getMetadataManager().saveExternalFilter(desc);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeExternalFilter(String name) throws IOException {
        this.getMetadataManager().removeExternalFilter(name);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void syncExtFilterToProject(String[] filters, String project) throws IOException {
        this.getProjectManager().addExtFilterToProject(filters, project);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeExtFilterFromProject(String filterName, String projectName) throws IOException {
        this.getProjectManager().removeExtFilterFromProject(filterName, projectName);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<ExternalFilterDesc> listAllExternalFilters() {
        return this.getMetadataManager().listAllExternalFilters();
    }
}

