/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.CuboidCLI;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.MetricsRequest;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.HBaseRegionSizeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="cubeMgmtService")
public class CubeService
extends BasicService {
    private static final String DESC_SUFFIX = "_desc";
    private static final Logger logger = LoggerFactory.getLogger(CubeService.class);
    private WeakHashMap<String, HBaseResponse> htableInfoCache = new WeakHashMap();
    @Autowired
    private AccessService accessService;
    @Autowired
    private JobService jobService;

    @PostFilter(value="hasRole('ROLE_ADMIN') or hasPermission(filterObject, 'READ') or hasPermission(filterObject, 'MANAGEMENT') or hasPermission(filterObject, 'OPERATION') or hasPermission(filterObject, 'ADMINISTRATION')")
    public List<CubeInstance> listAllCubes(String cubeName, String projectName, String modelName) {
        List<CubeInstance> cubeInstances = null;
        ProjectInstance project = null != projectName ? this.getProjectManager().getProject(projectName) : null;
        cubeInstances = null == project ? this.getCubeManager().listAllCubes() : this.listAllCubes(projectName);
        List<Object> filterModelCubes = new ArrayList();
        if (modelName != null) {
            for (CubeInstance cubeInstance : cubeInstances) {
                boolean bl = cubeInstance.getDescriptor().getModelName().toLowerCase().equals(modelName.toLowerCase());
                if (!bl) continue;
                filterModelCubes.add(cubeInstance);
            }
        } else {
            filterModelCubes = cubeInstances;
        }
        ArrayList<CubeInstance> filterCubes = new ArrayList<CubeInstance>();
        for (CubeInstance cubeInstance : filterModelCubes) {
            boolean isCubeMatch = null == cubeName || cubeInstance.getName().toLowerCase().contains(cubeName.toLowerCase());
            if (!isCubeMatch) continue;
            filterCubes.add(cubeInstance);
        }
        return filterCubes;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance updateCubeCost(CubeInstance cube, int cost) throws IOException {
        if (cube.getCost() == cost) {
            return cube;
        }
        cube.setCost(cost);
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        cube.setOwner(owner);
        CubeUpdate cubeBuilder = new CubeUpdate(cube).setOwner(owner).setCost(cost);
        return this.getCubeManager().updateCube(cubeBuilder);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_MODELER')")
    public CubeInstance createCubeAndDesc(String cubeName, String projectName, CubeDesc desc) throws IOException {
        if (this.getCubeManager().getCube(cubeName) != null) {
            throw new InternalErrorException("The cube named " + cubeName + " already exists");
        }
        if (this.getCubeDescManager().getCubeDesc(desc.getName()) != null) {
            throw new InternalErrorException("The cube desc named " + desc.getName() + " already exists");
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        CubeDesc createdDesc = this.getCubeDescManager().createCubeDesc(desc);
        if (!createdDesc.getError().isEmpty()) {
            this.getCubeDescManager().removeCubeDesc(createdDesc);
            throw new InternalErrorException((String)createdDesc.getError().get(0));
        }
        try {
            int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)createdDesc, (boolean)false);
            logger.info("New cube " + cubeName + " has " + cuboidCount + " cuboids");
        }
        catch (Exception e) {
            this.getCubeDescManager().removeCubeDesc(createdDesc);
            throw new InternalErrorException("Failed to deal with the request.", e);
        }
        CubeInstance createdCube = this.getCubeManager().createCube(cubeName, projectName, createdDesc, owner);
        this.accessService.init((AclEntity)createdCube, AclPermission.ADMINISTRATION);
        ProjectInstance project = this.getProjectManager().getProject(projectName);
        this.accessService.inherit((AclEntity)createdCube, (AclEntity)project);
        return createdCube;
    }

    public List<CubeInstance> listAllCubes(String projectName) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube != null) {
                result.add(cube);
                continue;
            }
            logger.error("Cube instance " + projectDataModel.getRealization() + " is failed to load");
        }
        return result;
    }

    private boolean isCubeInProject(String projectName, CubeInstance target) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return false;
        }
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube == null) {
                logger.error("Project " + projectName + " contains realization " + projectDataModel.getRealization() + " which is not found by CubeManager");
                continue;
            }
            if (!cube.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public CubeDesc updateCubeAndDesc(CubeInstance cube, CubeDesc desc, String newProjectName, boolean forceUpdate) throws IOException, JobException {
        List<CubingJob> cubingJobs = this.jobService.listAllCubingJobs(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new JobException("Cube schema shouldn't be changed with running job.");
        }
        try {
            if (!forceUpdate && !cube.getDescriptor().consistentWith(desc)) {
                throw new IllegalStateException("cube's desc is not consistent with the new desc");
            }
            CubeDesc updatedCubeDesc = this.getCubeDescManager().updateCubeDesc(desc);
            int cuboidCount = CuboidCLI.simulateCuboidGeneration((CubeDesc)updatedCubeDesc, (boolean)false);
            logger.info("Updated cube " + cube.getName() + " has " + cuboidCount + " cuboids");
            ProjectManager projectManager = this.getProjectManager();
            if (!this.isCubeInProject(newProjectName, cube)) {
                String owner = SecurityContextHolder.getContext().getAuthentication().getName();
                ProjectInstance newProject = projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), newProjectName, owner);
                this.accessService.inherit((AclEntity)cube, (AclEntity)newProject);
            }
            return updatedCubeDesc;
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to deal with the request.", e);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'MANAGEMENT')")
    public void deleteCube(CubeInstance cube) throws IOException, JobException {
        List<CubingJob> cubingJobs = this.jobService.listAllCubingJobs(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR));
        if (!cubingJobs.isEmpty()) {
            throw new JobException("The cube " + cube.getName() + " has running or failed job, please discard it and try again.");
        }
        try {
            this.releaseAllJobs(cube);
        }
        catch (Exception e) {
            logger.error("error when releasing all jobs", (Throwable)e);
        }
        int cubeNum = this.getCubeManager().getCubesByDesc(cube.getDescriptor().getName()).size();
        this.getCubeManager().dropCube(cube.getName(), cubeNum == 1);
        this.accessService.clean((AclEntity)cube, true);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION') or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance purgeCube(CubeInstance cube) throws IOException, JobException {
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.DISABLED.equals((Object)ostatus)) {
            throw new InternalErrorException("Only disabled cube can be purged, status of " + cubeName + " is " + ostatus);
        }
        this.releaseAllSegments(cube);
        return cube;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION') or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance disableCube(CubeInstance cube) throws IOException, JobException {
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.READY.equals((Object)ostatus)) {
            throw new InternalErrorException("Only ready cube can be disabled, status of " + cubeName + " is " + ostatus);
        }
        cube.setStatus(RealizationStatusEnum.DISABLED);
        try {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setStatus(RealizationStatusEnum.DISABLED);
            return this.getCubeManager().updateCube(cubeBuilder);
        }
        catch (IOException e) {
            cube.setStatus(ostatus);
            throw e;
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION')  or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance enableCube(CubeInstance cube) throws IOException, JobException {
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (!cube.getStatus().equals((Object)RealizationStatusEnum.DISABLED)) {
            throw new InternalErrorException("Only disabled cube can be enabled, status of " + cubeName + " is " + ostatus);
        }
        if (cube.getSegments(SegmentStatusEnum.READY).size() == 0) {
            throw new InternalErrorException("Cube " + cubeName + " doesn't contain any READY segment");
        }
        List<CubingJob> cubingJobs = this.jobService.listAllCubingJobs(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new JobException("Enable is not allowed with a running job.");
        }
        if (!cube.getDescriptor().checkSignature()) {
            throw new IllegalStateException("Inconsistent cube desc signature for " + cube.getDescriptor() + ", if it's right after a upgrade, please try 'Edit CubeDesc' to delete the 'signature' field. Or use 'bin/metastore.sh refresh-cube-signature' to batch refresh all cubes' signatures, then reload metadata to take effect");
        }
        try {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setStatus(RealizationStatusEnum.READY);
            return this.getCubeManager().updateCube(cubeBuilder);
        }
        catch (IOException e) {
            cube.setStatus(ostatus);
            throw e;
        }
    }

    public MetricsResponse calculateMetrics(MetricsRequest request) {
        List cubes = this.getCubeManager().listAllCubes();
        MetricsResponse metrics = new MetricsResponse();
        Date startTime = null == request.getStartTime() ? new Date(-1L) : request.getStartTime();
        Date endTime = null == request.getEndTime() ? new Date() : request.getEndTime();
        metrics.increase("totalCubes", Float.valueOf(0.0f));
        metrics.increase("totalStorage", Float.valueOf(0.0f));
        for (CubeInstance cube : cubes) {
            Date createdDate = new Date(-1L);
            createdDate = cube.getCreateTimeUTC() == 0L ? createdDate : new Date(cube.getCreateTimeUTC());
            if (createdDate.getTime() <= startTime.getTime() || createdDate.getTime() >= endTime.getTime()) continue;
            metrics.increase("totalCubes");
        }
        metrics.increase("aveStorage", Float.valueOf(((Float)metrics.get("totalCubes")).floatValue() == 0.0f ? 0.0f : ((Float)metrics.get("totalStorage")).floatValue() / ((Float)metrics.get("totalCubes")).floatValue()));
        return metrics;
    }

    public HBaseResponse getHTableInfo(String tableName) throws IOException {
        if (this.htableInfoCache.containsKey(tableName)) {
            return this.htableInfoCache.get(tableName);
        }
        Connection conn = HBaseConnection.get((String)this.getConfig().getStorageUrl());
        HBaseResponse hr = null;
        long tableSize = 0L;
        int regionCount = 0;
        HBaseRegionSizeCalculator cal = new HBaseRegionSizeCalculator(tableName, conn);
        Map sizeMap = cal.getRegionSizeMap();
        Iterator i$ = sizeMap.values().iterator();
        while (i$.hasNext()) {
            long s = (Long)i$.next();
            tableSize += s;
        }
        regionCount = sizeMap.size();
        hr = new HBaseResponse();
        hr.setTableSize(tableSize);
        hr.setRegionCount(regionCount);
        this.htableInfoCache.put(tableName, hr);
        return hr;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION')  or hasPermission(#cube, 'MANAGEMENT')")
    public void updateCubeNotifyList(CubeInstance cube, List<String> notifyList) throws IOException {
        CubeDesc desc = cube.getDescriptor();
        desc.setNotifyList(notifyList);
        this.getCubeDescManager().updateCubeDesc(desc);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION')  or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance rebuildLookupSnapshot(CubeInstance cube, String segmentName, String lookupTable) throws IOException {
        CubeSegment seg = cube.getSegment(segmentName, SegmentStatusEnum.READY);
        this.getCubeManager().buildSnapshotTable(seg, lookupTable);
        return cube;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#cube, 'ADMINISTRATION') or hasPermission(#cube, 'OPERATION')  or hasPermission(#cube, 'MANAGEMENT')")
    public CubeInstance deleteSegment(CubeInstance cube, String segmentName) throws IOException {
        if (!segmentName.equals(((CubeSegment)cube.getSegments().get(0)).getName()) && !segmentName.equals(((CubeSegment)cube.getSegments().get(cube.getSegments().size() - 1)).getName())) {
            throw new IllegalArgumentException("Cannot delete segment '" + segmentName + "' as it is neither the first nor the last segment.");
        }
        CubeSegment toDelete = null;
        for (CubeSegment seg : cube.getSegments()) {
            if (!seg.getName().equals(segmentName)) continue;
            toDelete = seg;
        }
        if (toDelete == null) {
            throw new IllegalArgumentException("Cannot find segment '" + segmentName + "'");
        }
        if (toDelete.getStatus() != SegmentStatusEnum.READY) {
            throw new IllegalArgumentException("Cannot delete segment '" + segmentName + "' as its status is not READY. Discard the on-going job for it.");
        }
        CubeUpdate update = new CubeUpdate(cube);
        update.setToRemoveSegs(new CubeSegment[]{toDelete});
        return CubeManager.getInstance((KylinConfig)this.getConfig()).updateCube(update);
    }

    private void releaseAllJobs(CubeInstance cube) {
        List<CubingJob> cubingJobs = this.jobService.listAllCubingJobs(cube.getName(), null);
        for (CubingJob cubingJob : cubingJobs) {
            ExecutableState status = cubingJob.getStatus();
            if (status == ExecutableState.SUCCEED || status == ExecutableState.DISCARDED) continue;
            this.getExecutableManager().discardJob(cubingJob.getId());
        }
    }

    private void releaseAllSegments(CubeInstance cube) throws IOException, JobException {
        this.releaseAllJobs(cube);
        CubeUpdate update = new CubeUpdate(cube);
        update.setToRemoveSegs((CubeSegment[])cube.getSegments().toArray((Object[])new CubeSegment[cube.getSegments().size()]));
        CubeManager.getInstance((KylinConfig)this.getConfig()).updateCube(update);
    }

    public void updateOnNewSegmentReady(String cubeName) {
        CubeSegment seg;
        CubeInstance cube;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverMode = kylinConfig.getServerMode();
        if (("job".equals(serverMode.toLowerCase()) || "all".equals(serverMode.toLowerCase())) && (cube = this.getCubeManager().getCube(cubeName)) != null && (seg = cube.getLatestBuiltSegment()) != null && seg.getStatus() == SegmentStatusEnum.READY) {
            this.keepCubeRetention(cubeName);
            this.mergeCubeSegment(cubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCubeRetention(String cubeName) {
        logger.info("checking keepCubeRetention");
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        CubeDesc desc = cube.getDescriptor();
        if (desc.getRetentionRange() <= 0L) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            cube = this.getCubeManager().getCube(cubeName);
            Segments readySegs = cube.getSegments(SegmentStatusEnum.READY);
            if (readySegs.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            ArrayList toRemoveSegs = Lists.newArrayList();
            long tail = ((CubeSegment)readySegs.get(readySegs.size() - 1)).getDateRangeEnd();
            long head = tail - desc.getRetentionRange();
            for (CubeSegment seg : readySegs) {
                if (seg.getDateRangeEnd() <= 0L || seg.getDateRangeEnd() > head) continue;
                toRemoveSegs.add(seg);
            }
            if (toRemoveSegs.size() > 0) {
                CubeUpdate cubeBuilder = new CubeUpdate(cube);
                cubeBuilder.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[toRemoveSegs.size()]));
                try {
                    this.getCubeManager().updateCube(cubeBuilder);
                }
                catch (IOException e) {
                    logger.error("Failed to remove old segment from cube " + cubeName, (Throwable)e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeCubeSegment(String cubeName) {
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        if (!cube.needAutoMerge()) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            try {
                cube = this.getCubeManager().getCube(cubeName);
                Pair offsets = this.getCubeManager().autoMergeCubeSegments(cube);
                if (offsets != null) {
                    CubeSegment newSeg = this.getCubeManager().mergeSegments(cube, 0L, 0L, ((Long)offsets.getFirst()).longValue(), ((Long)offsets.getSecond()).longValue(), true);
                    logger.debug("Will submit merge job on " + newSeg);
                    DefaultChainedExecutable job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)"SYSTEM");
                    this.getExecutableManager().addJob((AbstractExecutable)job);
                } else {
                    logger.debug("Not ready for merge on cube " + cubeName);
                }
            }
            catch (IOException e) {
                logger.error("Failed to auto merge cube " + cubeName, (Throwable)e);
            }
            return;
        }
    }
}

