/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import net.sf.ehcache.CacheManager;
import org.apache.calcite.jdbc.Driver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.query.schema.OLAPSchemaFactory;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component(value="cacheService")
public class CacheService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private ConcurrentMap<String, DataSource> olapDataSources = new ConcurrentHashMap<String, DataSource>();
    @Autowired
    private CubeService cubeService;
    @Autowired
    private CacheManager cacheManager;
    private Broadcaster.Listener cacheSyncListener = new Broadcaster.Listener(){

        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CacheService.this.removeAllOLAPDataSources();
            CacheService.this.cleanAllDataCache();
        }

        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            CacheService.this.removeOLAPDataSource(project);
            CacheService.this.cleanDataCache(project);
        }

        public void onProjectDataChange(Broadcaster broadcaster, String project) throws IOException {
            CacheService.this.removeOLAPDataSource(project);
            CacheService.this.cleanDataCache(project);
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if ("cube".equals(entity) && event == Broadcaster.Event.UPDATE) {
                final String cubeName = cacheKey;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            CacheService.this.cubeService.updateOnNewSegmentReady(cubeName);
                        }
                        catch (Throwable ex) {
                            logger.error("Error in updateOnNewSegmentReady()", ex);
                        }
                    }
                }.start();
            }
        }
    };

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    public void annouceWipeCache(String entity, String event, String cacheKey) {
        Broadcaster broadcaster = Broadcaster.getInstance((KylinConfig)this.getConfig());
        broadcaster.queue(entity, event, cacheKey);
    }

    public void notifyMetadataChange(String entity, Broadcaster.Event event, String cacheKey) throws IOException {
        Broadcaster broadcaster = Broadcaster.getInstance((KylinConfig)this.getConfig());
        broadcaster.registerListener(this.cacheSyncListener, new String[]{"cube"});
        broadcaster.notifyListener(entity, event, cacheKey);
    }

    protected void cleanDataCache(String project) {
        if (this.cacheManager != null) {
            logger.info("cleaning cache for project " + project + " (currently remove all entries)");
            this.cacheManager.getCache("StorageCache").removeAll();
            this.cacheManager.getCache("ExceptionQueryCache").removeAll();
        } else {
            logger.warn("skip cleaning cache for project " + project);
        }
    }

    protected void cleanAllDataCache() {
        if (this.cacheManager != null) {
            logger.warn("cleaning all storage cache");
            this.cacheManager.clearAll();
        } else {
            logger.warn("skip cleaning all storage cache");
        }
    }

    private void removeOLAPDataSource(String project) {
        logger.info("removeOLAPDataSource is called for project " + project);
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new IllegalArgumentException("removeOLAPDataSource: project name not given");
        }
        project = ProjectInstance.getNormalizedProjectName((String)project);
        this.olapDataSources.remove(project);
    }

    public void removeAllOLAPDataSources() {
        logger.info("removeAllOLAPDataSources is called.");
        this.olapDataSources.clear();
    }

    public DataSource getOLAPDataSource(String project) {
        DataSource ret = (DataSource)this.olapDataSources.get(project = ProjectInstance.getNormalizedProjectName((String)project));
        if (ret == null) {
            logger.debug("Creating a new data source, OLAP data source pointing to " + this.getConfig());
            File modelJson = OLAPSchemaFactory.createTempOLAPJson((String)project, (KylinConfig)this.getConfig());
            try {
                String text = FileUtils.readFileToString((File)modelJson, (Charset)Charset.defaultCharset());
                logger.debug("The new temp olap json is :" + text);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DriverManagerDataSource ds = new DriverManagerDataSource();
            ds.setDriverClassName(Driver.class.getName());
            ds.setUrl("jdbc:calcite:model=" + modelJson.getAbsolutePath());
            ret = this.olapDataSources.putIfAbsent(project, (DataSource)ds);
            if (ret == null) {
                ret = ds;
            }
        }
        return ret;
    }
}

