/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.tool.StorageCleanupJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="adminService")
public class AdminService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(AdminService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String getEnv() {
        PropertiesConfiguration tempConfig = new PropertiesConfiguration();
        OrderedProperties orderedProperties = new OrderedProperties(new TreeMap());
        try {
            String content = "";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Map<String, String> env = System.getenv();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                orderedProperties.setProperty(entry.getKey(), entry.getValue());
            }
            Properties properties = System.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                orderedProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : orderedProperties.entrySet()) {
                tempConfig.addProperty((String)entry.getKey(), entry.getValue());
            }
            tempConfig.save((OutputStream)baos);
            content = baos.toString();
            return content;
        }
        catch (ConfigurationException e) {
            throw new InternalErrorException("Failed to get Kylin env Config", e);
        }
    }

    public String getConfigAsString() {
        logger.debug("Get Kylin Runtime Config");
        try {
            return KylinConfig.getInstanceFromEnv().getConfigAsString();
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to get Kylin Runtime Config", e);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void cleanupStorage() {
        StorageCleanupJob job = new StorageCleanupJob();
        String[] args = new String[]{"-delete", "true"};
        try {
            job.execute(args);
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage(), e);
        }
    }
}

