/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.AclHBaseStorage;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.storage.hbase.HBaseConnection;

public class RealAclHBaseStorage
implements AclHBaseStorage {
    private String hbaseUrl;
    private String aclTableName;
    private String userTableName;

    @Override
    public String prepareHBaseTable(Class<?> clazz) throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String metadataUrl = kylinConfig.getMetadataUrl();
        int cut = metadataUrl.indexOf(64);
        this.hbaseUrl = cut < 0 ? metadataUrl : metadataUrl.substring(cut + 1);
        String tableNameBase = kylinConfig.getMetadataUrlPrefix();
        if (clazz == AclService.class) {
            this.aclTableName = tableNameBase + "_acl";
            HBaseConnection.createHTableIfNeeded((String)this.hbaseUrl, (String)this.aclTableName, (String[])new String[]{"i", "a"});
            return this.aclTableName;
        }
        if (clazz == UserService.class) {
            this.userTableName = tableNameBase + "_user";
            HBaseConnection.createHTableIfNeeded((String)this.hbaseUrl, (String)this.userTableName, (String[])new String[]{"a", "q"});
            return this.userTableName;
        }
        throw new IllegalStateException("prepareHBaseTable for unknown class: " + clazz);
    }

    @Override
    public Table getTable(String tableName) throws IOException {
        if (StringUtils.equals((String)tableName, (String)this.aclTableName)) {
            return HBaseConnection.get((String)this.hbaseUrl).getTable(TableName.valueOf((String)this.aclTableName));
        }
        if (StringUtils.equals((String)tableName, (String)this.userTableName)) {
            return HBaseConnection.get((String)this.hbaseUrl).getTable(TableName.valueOf((String)this.userTableName));
        }
        throw new IllegalStateException("getTable failed" + tableName);
    }
}

