/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class AuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    SimpleGrantedAuthority adminRoleAsAuthority;
    SimpleGrantedAuthority adminAuthority = new SimpleGrantedAuthority("ROLE_ADMIN");
    SimpleGrantedAuthority modelerAuthority = new SimpleGrantedAuthority("ROLE_MODELER");
    SimpleGrantedAuthority analystAuthority = new SimpleGrantedAuthority("ROLE_ANALYST");
    Set<GrantedAuthority> defaultAuthorities = new HashSet<GrantedAuthority>();

    public AuthoritiesPopulator(ContextSource contextSource, String groupSearchBase, String adminRole, String defaultRole) {
        super(contextSource, groupSearchBase);
        this.adminRoleAsAuthority = new SimpleGrantedAuthority(adminRole);
        Object[] defaultRoles = StringUtils.split((String)defaultRole, (String)",");
        if (ArrayUtils.contains((Object[])defaultRoles, (Object)"ROLE_MODELER")) {
            this.defaultAuthorities.add((GrantedAuthority)this.modelerAuthority);
        }
        if (ArrayUtils.contains((Object[])defaultRoles, (Object)"ROLE_ANALYST")) {
            this.defaultAuthorities.add((GrantedAuthority)this.analystAuthority);
        }
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        Set authorities = super.getGroupMembershipRoles(userDn, username);
        authorities.addAll(this.defaultAuthorities);
        if (authorities.contains(this.adminRoleAsAuthority)) {
            authorities.add(this.adminAuthority);
            authorities.add(this.modelerAuthority);
            authorities.add(this.analystAuthority);
        }
        if (authorities.contains(this.modelerAuthority)) {
            authorities.add(this.analystAuthority);
        }
        return authorities;
    }
}

