/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.service.CacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cache"})
public class CacheController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(CacheController.class);
    @Autowired
    private CacheService cacheService;

    @RequestMapping(value={"/announce/{entity}/{cacheKey}/{event}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void announceWipeCache(@PathVariable String entity, @PathVariable String event, @PathVariable String cacheKey) throws IOException {
        this.cacheService.annouceWipeCache(entity, event, cacheKey);
    }

    @RequestMapping(value={"/{entity}/{cacheKey}/{event}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void wipeCache(@PathVariable String entity, @PathVariable String event, @PathVariable String cacheKey) throws IOException {
        this.cacheService.notifyMetadataChange(entity, Broadcaster.Event.getEvent((String)event), cacheKey);
    }

    @RequestMapping(value={"/announce/config"}, method={RequestMethod.POST})
    public void hotLoadKylinConfig() throws IOException {
        KylinConfig.getInstanceFromEnv().hotLoadKylinProperties();
        this.cacheService.notifyMetadataChange("all", Broadcaster.Event.UPDATE, "all");
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

