/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.SnapshotSourceTableStatsRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.SnapshotSourceTableStatsResponse;
import org.apache.kylin.rest.service.SnapshotSourceTableStatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/snapshots"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class SnapshotSourceTableStatsController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotSourceTableStatsController.class);
    @Autowired
    @Qualifier(value="snapshotSourceTableStatsService")
    private SnapshotSourceTableStatsService snapshotSourceTableStatsService;

    @ApiOperation(value="check source table stats", tags={"Apollo"})
    @PostMapping(value={"source_table_stats"})
    @ResponseBody
    public EnvelopeResponse<SnapshotSourceTableStatsResponse> sourceTableStats(@Valid @RequestBody SnapshotSourceTableStatsRequest request) {
        log.debug("sourceTableStats request : {}", (Object)request);
        String project = this.checkProjectName(request.getProject());
        SnapshotSourceTableStatsResponse response = this.snapshotSourceTableStatsService.checkSourceTableStats(project, request.getDatabase(), request.getTable(), request.getSnapshotPartitionCol(), request.getCatalog());
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="save snapshot view - sourceTable mapping", tags={"Apollo"})
    @PostMapping(value={"view_mapping"})
    @ResponseBody
    public EnvelopeResponse<Boolean> saveSnapshotViewMapping(@RequestBody SnapshotSourceTableStatsRequest request) {
        log.debug("saveSnapshotViewMapping request : {}", (Object)request);
        String project = this.checkProjectName(request.getProject());
        Boolean result = this.snapshotSourceTableStatsService.saveSnapshotViewMapping(project);
        return new EnvelopeResponse("000", (Object)result, "");
    }
}

