/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.kylin.sdk.datasource.framework.conv.ConvSqlWriter;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;

public class ConvRownumSqlWriter
extends ConvSqlWriter {
    private boolean printSelectForRownumInWithCLause = false;
    private static final String ALIAS_ROWNUM = "ROWNUM__";
    private static final String SQL_ROWSTART = "SELECT * \nFROM(\n\tSELECT T.*, ROWNUM ROWNUM__\n\tFROM ( \n\t";
    private static final String SQL_ROWEND_NOLIMIT = "\n\t) T\n) ";
    private static final String SQL_ROWEND_LIMIT_INNER = "\n\t) T WHERE ROWNUM <= ";
    private static final String SQL_ROWEND_LIMIT_OUTER = " \n) \nWHERE 1 = 1 AND ";
    private Deque<String> lastAliasRownumNameStack = new ArrayDeque<String>();
    private int rownumCounter = 1;

    ConvRownumSqlWriter(SqlConverter.IConfigurer configurer) throws SQLException {
        super(configurer);
    }

    protected SqlWriter.Frame startList(SqlWriter.FrameType frameType, String keyword, String open, String close) {
        if (this.frame != null && this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY && (frameType == SqlWriter.FrameTypeEnum.SELECT || frameType == SqlWriter.FrameTypeEnum.SETOP || frameType == SqlWriter.FrameTypeEnum.SIMPLE)) {
            this.keyword(this.masageSqlRowStart());
        }
        return super.startList(frameType, keyword, open, close);
    }

    @Override
    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        this.doWriteRowNum(fetch, offset);
    }

    @Override
    protected void doWriteRowNum(SqlNode fetch, SqlNode offset) {
        if (this.frame != null && this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY) {
            SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
            this.newlineAndIndent();
            if (fetch != null) {
                this.keyword(SQL_ROWEND_LIMIT_INNER);
                fetch.unparse((SqlWriter)this, -1, -1);
                if (offset != null) {
                    this.keyword(" + ");
                    offset.unparse((SqlWriter)this, -1, -1);
                }
                this.keyword(SQL_ROWEND_LIMIT_OUTER);
                String lastAliasRownumName = this.lastAliasRownumNameStack.isEmpty() ? "ROWNUM" : this.lastAliasRownumNameStack.pop();
                this.keyword(lastAliasRownumName);
                if (offset != null) {
                    this.keyword(" BETWEEN ");
                    offset.unparse((SqlWriter)this, -1, -1);
                    this.keyword(" + 1 AND ");
                    offset.unparse((SqlWriter)this, -1, -1);
                    this.keyword(" + ");
                    fetch.unparse((SqlWriter)this, -1, -1);
                } else {
                    this.keyword(" <= ");
                    fetch.unparse((SqlWriter)this, -1, -1);
                }
            } else {
                if (!this.lastAliasRownumNameStack.isEmpty()) {
                    this.lastAliasRownumNameStack.pop();
                }
                this.keyword(SQL_ROWEND_NOLIMIT);
            }
            this.endList(fetchFrame);
        }
    }

    @Override
    public void writeWith(SqlCall call, int leftPrec, int rightPrec) {
        this.printSelectForRownumInWithCLause = this.frame != null && this.frame.frameType == SqlWriter.FrameTypeEnum.ORDER_BY;
        super.writeWith(call, leftPrec, rightPrec);
    }

    @Override
    protected void outputBetweenWithListAndWithbody() {
        if (this.printSelectForRownumInWithCLause) {
            this.keyword(this.masageSqlRowStart());
        }
    }

    private String masageSqlRowStart() {
        String lastAliasRownumName = ALIAS_ROWNUM + this.rownumCounter;
        ++this.rownumCounter;
        this.lastAliasRownumNameStack.push(lastAliasRownumName);
        return SQL_ROWSTART.replace(ALIAS_ROWNUM, lastAliasRownumName);
    }
}

