/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Litmus;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.sdk.datasource.framework.conv.ParamNodeParser;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.TypeDef;

public class ConvMaster {
    private final DataSourceDef sourceDS;
    private final DataSourceDef targetDS;

    public ConvMaster(DataSourceDef sourceDS, DataSourceDef targetDS) {
        this.sourceDS = sourceDS;
        this.targetDS = targetDS;
    }

    Pair<SqlNode, SqlNode> matchSqlFunc(SqlNode sourceFunc) {
        String funcName;
        List<String> validDefIds;
        if (sourceFunc == null || this.sourceDS == null || this.targetDS == null) {
            return null;
        }
        if ((sourceFunc instanceof SqlCall || sourceFunc instanceof SqlIdentifier) && (validDefIds = this.sourceDS.getFuncDefsByName(funcName = sourceFunc instanceof SqlCall ? ((SqlCall)sourceFunc).getOperator().getName() : sourceFunc.toString())) != null) {
            for (String defId : validDefIds) {
                SqlNode targetTmpl;
                SqlNode sourceCandidate = this.sourceDS.getFuncDefSqlNode(defId);
                if (!ExpressionComparator.isNodeEqual((SqlNode)sourceFunc, (SqlNode)sourceCandidate, (ExpressionComparator.SqlNodeComparator)new ParamSqlNodeComparator()) || (targetTmpl = this.targetDS.getFuncDefSqlNode(defId)) == null) continue;
                return new Pair((Object)sourceCandidate, (Object)this.targetDS.getFuncDefSqlNode(defId));
            }
        }
        return null;
    }

    SqlDataTypeSpec findTargetSqlDataTypeSpec(SqlDataTypeSpec typeSpec) {
        if (this.sourceDS == null || this.targetDS == null || typeSpec == null) {
            return null;
        }
        List<TypeDef> validTypeDefs = this.sourceDS.getTypeDefsByName(typeSpec.getTypeName().toString());
        if (validTypeDefs == null || validTypeDefs.isEmpty()) {
            return null;
        }
        for (TypeDef typeDef : validTypeDefs) {
            TypeDef targetType = this.targetDS.getTypeDef(typeDef.getId());
            if (targetType == null) {
                return null;
            }
            SqlTypeNameSpec typeNameSpec = typeSpec.getTypeNameSpec();
            if (!(typeNameSpec instanceof SqlBasicTypeNameSpec)) {
                return null;
            }
            SqlBasicTypeNameSpec basicTypeNameSpec = (SqlBasicTypeNameSpec)typeNameSpec;
            SqlTypeName targetTypeName = SqlTypeName.get((String)targetType.getName());
            if (typeDef.getMaxPrecision() < basicTypeNameSpec.getPrecision()) continue;
            if (targetTypeName != null) {
                return new SqlDataTypeSpec((SqlTypeNameSpec)basicTypeNameSpec, typeSpec.getParserPosition());
            }
            SqlTypeName aliasTypeName = SqlTypeName.get((String)basicTypeNameSpec.getTypeName().getSimple());
            if (aliasTypeName == null) continue;
            return new SqlDataTypeSpec((SqlTypeNameSpec)new SqlAlienSystemTypeNameSpec(targetType.getName(), aliasTypeName, SqlParserPos.ZERO), SqlParserPos.ZERO);
        }
        return null;
    }

    boolean checkNodeEqual(SqlNode node1, SqlNode node2) {
        return ExpressionComparator.isNodeEqual((SqlNode)node1, (SqlNode)node2, (ExpressionComparator.SqlNodeComparator)new ParamSqlNodeComparator());
    }

    private static class ParamSqlNodeComparator
    extends ExpressionComparator.SqlNodeComparator {
        private final Map<Integer, SqlNode> matchedNodesMap;

        private ParamSqlNodeComparator() {
            this(Maps.newHashMap());
        }

        private ParamSqlNodeComparator(Map<Integer, SqlNode> matchedNodesMap) {
            this.matchedNodesMap = matchedNodesMap;
        }

        public boolean isSqlIdentifierEqual(SqlIdentifier querySqlIdentifier, SqlIdentifier exprSqlIdentifier) {
            int parsedIdx = ParamNodeParser.parseParamIdx(exprSqlIdentifier.toString());
            if (parsedIdx >= 0) {
                SqlNode matchedBefore = this.matchedNodesMap.get(parsedIdx);
                if (matchedBefore != null) {
                    return ExpressionComparator.isNodeEqual((SqlNode)querySqlIdentifier, (SqlNode)matchedBefore, (ExpressionComparator.SqlNodeComparator)this);
                }
                this.matchedNodesMap.put(parsedIdx, (SqlNode)querySqlIdentifier);
                return true;
            }
            return querySqlIdentifier.equalsDeep((SqlNode)exprSqlIdentifier, Litmus.IGNORE);
        }

        public boolean isSqlNodeEqual(SqlNode queryNode, SqlNode exprNode) {
            if (queryNode != null && exprNode != null) {
                if (exprNode instanceof SqlIdentifier) {
                    int parsedIdx = ParamNodeParser.parseParamIdx(exprNode.toString());
                    if (parsedIdx >= 0) {
                        SqlNode matchedBefore = this.matchedNodesMap.get(parsedIdx);
                        if (matchedBefore != null) {
                            return ExpressionComparator.isNodeEqual((SqlNode)queryNode, (SqlNode)matchedBefore, (ExpressionComparator.SqlNodeComparator)this);
                        }
                        this.matchedNodesMap.put(parsedIdx, queryNode);
                        return true;
                    }
                } else {
                    if (exprNode instanceof SqlIntervalQualifier) {
                        if (!(queryNode instanceof SqlIntervalQualifier)) {
                            return false;
                        }
                        SqlIntervalQualifier thisNode = (SqlIntervalQualifier)queryNode;
                        SqlIntervalQualifier thatNode = (SqlIntervalQualifier)exprNode;
                        return thisNode.toString().equals(thatNode.toString());
                    }
                    if (exprNode instanceof SqlWindow) {
                        if (!(queryNode instanceof SqlWindow)) {
                            return false;
                        }
                        if (((SqlWindow)exprNode).getRefName() instanceof SqlIdentifier) {
                            return true;
                        }
                    }
                }
            }
            return super.isSqlNodeEqual(queryNode, exprNode);
        }
    }
}

