/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.service.JobInfoService;
import org.apache.kylin.rest.util.SparkUIUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="JobDriverUIUtil")
public class JobDriverUIUtil {
    public static final String DRIVER_UI_BASE = "/driver_ui";
    public static final String KYLIN_DRIVER_UI_BASE = "/kylin/driver_ui";
    public static final String PROXY_LOCATION_BASE = KylinConfig.getInstanceFromEnv().getUIProxyLocation() + "/driver_ui";
    @Autowired
    private JobInfoService jobInfoService;

    public void proxy(String project, String jobStep, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String originUiUrl = this.getOriginUiUrl(project, jobStep);
        if (StringUtils.isEmpty((CharSequence)originUiUrl)) {
            servletResponse.getWriter().write("track url not generated yet");
            return;
        }
        String requestBasePath = "/kylin/driver_ui/" + project + "/" + jobStep;
        String uriPath = servletRequest.getRequestURI().substring(requestBasePath.length());
        try {
            SparkUIUtil.resendSparkUIRequest((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, (String)originUiUrl, (String)uriPath, (String)(PROXY_LOCATION_BASE + "/" + project + "/" + jobStep));
        }
        catch (UnknownHostException e) {
            servletResponse.getWriter().write("track url invalid already ");
        }
    }

    private String getOriginUiUrl(String project, String jobStep) {
        String trackUrl = this.jobInfoService.getOriginTrackUrlByProjectAndStepId(project, jobStep);
        return trackUrl;
    }

    public static String getProxyUrl(String project, String jobStep) {
        return PROXY_LOCATION_BASE + "/" + project + "/" + jobStep;
    }
}

