/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.constant.JobActionEnum;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.rest.JobFilter;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ExecutableResponse;
import org.apache.kylin.rest.service.JobInfoService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/jobs"}, produces={"application/vnd.apache.kylin-v2+json"})
public class JobControllerV2
extends BaseController {
    private static final String JOB_ID_ARG_NAME = "jobId";
    private static final String STEP_ID_ARG_NAME = "stepId";
    @Autowired
    private JobInfoService jobInfoService;
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    public AclEvaluate aclEvaluate;

    @ApiOperation(value="resume", tags={"DW"})
    @PutMapping(value={"/{jobId}/resume"})
    @ResponseBody
    public EnvelopeResponse<ExecutableResponse> resume(@PathVariable(value="jobId") String jobId) throws IOException {
        this.checkRequiredArg(JOB_ID_ARG_NAME, jobId);
        ExecutableResponse jobInstance = this.jobInfoService.getJobInstance(jobId);
        this.aclEvaluate.checkProjectOperationPermission(jobInstance.getProject());
        return new EnvelopeResponse("000", (Object)this.jobInfoService.manageJob(jobInstance.getProject(), jobInstance, JobActionEnum.RESUME.toString()), "");
    }

    @ApiOperation(value="getJobList", tags={"DW"})
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse getJobList(@RequestParam(value="status", required=false, defaultValue="") Integer[] status, @RequestParam(value="timeFilter") Integer timeFilter, @RequestParam(value="jobName", required=false) String jobName, @RequestParam(value="projectName", required=false) String project, @RequestParam(value="key", required=false) String key, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", required=false, defaultValue="last_modified") String sortBy, @RequestParam(value="sortby", required=false) String sortby, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse) {
        if (!StringUtils.isEmpty((CharSequence)sortby) && !"last_modify".equals(sortby)) {
            sortBy = sortby;
        }
        this.checkNonNegativeIntegerArg("pageOffset", pageOffset);
        this.checkNonNegativeIntegerArg("pageSize", pageSize);
        ArrayList statuses = Lists.newArrayList();
        for (Integer code : status) {
            JobStatusEnum jobStatus = JobStatusEnum.getByCode((Integer)code);
            if (Objects.isNull(jobStatus)) {
                this.jobInfoService.checkJobStatus(String.valueOf(code));
                continue;
            }
            statuses.add(jobStatus);
        }
        JobFilter jobFilter = new JobFilter((List)statuses, Objects.isNull(jobName) ? JobTypeEnum.BUILD_JOB_TYPES : Lists.newArrayList((Object[])new String[]{jobName}), timeFilter.intValue(), null, key, false, project, sortBy, reverse.booleanValue());
        List executables = this.jobInfoService.listJobs(jobFilter);
        executables = this.jobInfoService.addOldParams(executables);
        long count = this.jobInfoService.countJobs(jobFilter);
        executables.forEach(executableResponse -> executableResponse.setVersion(KylinVersion.getCurrentVersion().toString()));
        HashMap result = this.getDataResponse("jobs", executables, (int)count, pageOffset, pageSize);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="getJob", tags={"DW"})
    @GetMapping(value={"/{jobId}"})
    @ResponseBody
    public EnvelopeResponse<ExecutableResponse> getJob(@PathVariable(value="jobId") String jobId) {
        this.checkRequiredArg(JOB_ID_ARG_NAME, jobId);
        ExecutableResponse jobInstance = this.jobInfoService.getJobInstance(jobId);
        List executables = Lists.newArrayList((Object[])new ExecutableResponse[]{jobInstance});
        executables = this.jobInfoService.addOldParams(executables);
        if (executables != null && executables.size() != 0) {
            jobInstance = (ExecutableResponse)executables.get(0);
        }
        if (jobInstance != null) {
            jobInstance.setVersion(KylinVersion.getCurrentVersion().toString());
        }
        return new EnvelopeResponse("000", (Object)jobInstance, "");
    }

    @ApiOperation(value="getJobOutput", tags={"DW"})
    @GetMapping(value={"/{job_id:.+}/steps/{step_id:.+}/output"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getJobOutput(@PathVariable(value="job_id") String jobId, @PathVariable(value="step_id") String stepId) {
        String project = this.jobInfoService.getProjectByJobId(jobId);
        this.checkProjectName(project);
        Map result = this.jobService.getStepOutput(project, jobId, stepId);
        result.put(JOB_ID_ARG_NAME, jobId);
        result.put(STEP_ID_ARG_NAME, stepId);
        return new EnvelopeResponse("000", (Object)result, "");
    }
}

