/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.token;

import java.util.ArrayList;
import java.util.Date;
import org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.tool.token.TokenCache;

public class TokenInit {
    public static AuthToken issueToken(String principal, String group, String role) {
        AuthToken authToken = KrbRuntime.getTokenProvider((String)"JWT").createTokenFactory().createToken();
        String iss = "token-service";
        authToken.setIssuer(iss);
        String sub = principal;
        authToken.setSubject(sub);
        authToken.addAttribute("group", (Object)group);
        if (role != null) {
            authToken.addAttribute("role", (Object)role);
        }
        ArrayList<String> aud = new ArrayList<String>();
        aud.add("krb5kdc-with-token-extension");
        authToken.setAudiences(aud);
        Date now = new Date(new Date().getTime() / 1000L * 1000L);
        Date exp = new Date(now.getTime() + 3600000L);
        authToken.setExpirationTime(exp);
        Date nbf = now;
        authToken.setNotBeforeTime(nbf);
        Date iat = now;
        authToken.setIssueTime(iat);
        return authToken;
    }

    public static void main(String[] args) throws Exception {
        String role = null;
        if (args.length != 2 && args.length != 3) {
            System.out.println("This is a simple token issuing tool just for kerb-token PoC usage\n");
            System.out.println("tokeninit <username> <group> [role]\n");
            System.exit(1);
        }
        String principal = args[0];
        String group = args[1];
        if (args.length > 2) {
            role = args[2];
        }
        TokenEncoder tokenEncoder = KrbRuntime.getTokenProvider((String)"JWT").createTokenEncoder();
        AuthToken token = TokenInit.issueToken(principal, group, role);
        String tokenStr = tokenEncoder.encodeAsString(token);
        TokenCache.writeToken(tokenStr);
        System.out.println("Issued token: " + tokenStr);
        TokenDecoder tokenDecoder = KrbRuntime.getTokenProvider((String)"JWT").createTokenDecoder();
        AuthToken token2 = tokenDecoder.decodeFromString(tokenStr);
        System.out.println("Decoded token's subject: " + token2.getSubject());
    }
}

