/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.klist;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptionGroup;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;

public enum KlistOption implements KOption
{
    NONE(null),
    CREDENTIALS_CACHE(new KOptionInfo("-c", "specifies path of credentials cache", KOptionType.STR)),
    KEYTAB(new KOptionInfo("-k", "specifies keytab")),
    DEFAULT_CLIENT_KEYTAB(new KOptionInfo("-i", "uses default client keytab if no name given")),
    LIST_CREDENTIAL_CACHES(new KOptionInfo("-l", "list credential caches in collection")),
    ALL_CREDENTIAL_CACHES(new KOptionInfo("-A", "shows content of all credential caches")),
    ENCRYPTION_TYPE(new KOptionInfo("-e", "shows encryption type")),
    KERBEROS_VERSION(new KOptionInfo("-V", "shows Kerberos version")),
    AUTHORIZATION_DATA_TYPE(new KOptionInfo("-d", "shows the submitted authorization data type")),
    CREDENTIALS_FLAGS(new KOptionInfo("-f", "show credential flags")),
    EXIT_TGT_EXISTENCE(new KOptionInfo("-s", "sets exit status based on valid tgt existence")),
    DISPL_ADDRESS_LIST(new KOptionInfo("-a", "displays the address list")),
    NO_REVERSE_RESOLVE(new KOptionInfo("-n", "do not reverse resolve")),
    SHOW_KTAB_ENTRY_TS(new KOptionInfo("-t", "shows keytab entry timestamps")),
    SHOW_KTAB_ENTRY_KEY(new KOptionInfo("-K", "show keytab entry keys")),
    CONF_DIR(new KOptionInfo("-conf", "conf dir", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.DIR));

    private final KOptionInfo optionInfo;

    private KlistOption(KOptionInfo optionInfo) {
        this.optionInfo = optionInfo;
    }

    public KOptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public static KlistOption fromName(String name) {
        if (name != null) {
            for (KlistOption ko : KlistOption.values()) {
                if (ko.optionInfo == null || !ko.optionInfo.getName().equals(name)) continue;
                return ko;
            }
        }
        return NONE;
    }
}

