/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.karaf.tooling.client.ClientMojo;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class DeployMojo
extends MojoSupport {
    @Parameter(defaultValue="8101")
    private int port;
    @Parameter(defaultValue="localhost")
    private String host;
    @Parameter(defaultValue="karaf")
    private String user;
    @Parameter(defaultValue="karaf")
    private String password;
    @Parameter(defaultValue="karaf-root")
    private String instance = "karaf-root";
    @Parameter(defaultValue="0")
    private int attempts;
    @Parameter(defaultValue="2")
    private int delay;
    @Parameter(defaultValue="true")
    private boolean useSsh = true;
    @Parameter(defaultValue="true")
    private boolean useProjectArtifact = true;
    @Parameter
    List<String> artifactLocations;
    @Parameter
    private File keyFile;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException {
        ArrayList<String> artifacts = new ArrayList<String>();
        if (this.useProjectArtifact) {
            Artifact projectArtifact = this.project.getArtifact();
            artifacts.add("mvn:" + projectArtifact.getGroupId() + "/" + projectArtifact.getArtifactId() + "/" + projectArtifact.getVersion());
        }
        artifacts.addAll(this.artifactLocations);
        if (this.useSsh) {
            this.deployWithSsh(this.artifactLocations);
        } else {
            this.deployWithJmx(this.artifactLocations);
        }
    }

    protected void deployWithJmx(List<String> locations) throws MojoExecutionException {
        try {
            JMXServiceURL jmxServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/" + this.instance);
            ArrayList<String> list = new ArrayList<String>();
            if (this.user != null) {
                list.add(this.user);
            }
            if (this.password != null) {
                list.add(this.password);
            }
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = list.toArray(new String[list.size()]);
            env.put("jmx.remote.credentials", credentials);
            JMXConnector jmxConnector = null;
            jmxConnector = credentials.length > 0 ? JMXConnectorFactory.connect(jmxServiceURL, env) : JMXConnectorFactory.connect(jmxServiceURL);
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            for (String location : locations) {
                mBeanServerConnection.invoke(new ObjectName("org.apache.karaf:type=bundle,name=*"), "install", new Object[]{location, true}, new String[]{"java.lang.String", "boolean"});
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't deploy using JMX", e);
        }
    }

    protected void deployWithSsh(List<String> locations) throws MojoExecutionException {
        SshClient client = null;
        try {
            boolean isError;
            final Console console = System.console();
            client = SshClient.setUpDefaultClient();
            this.setupAgent(this.user, this.keyFile, client);
            client.setUserInteraction(new UserInteraction(){

                public void welcome(String banner) {
                    console.printf(banner, new Object[0]);
                }

                public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                    String[] answers = new String[prompt.length];
                    try {
                        for (int i = 0; i < prompt.length; ++i) {
                            if (console == null) continue;
                            answers[i] = echo[i] ? console.readLine(prompt[i] + " ", new Object[0]) : new String(console.readPassword(prompt[i] + " ", new Object[0]));
                        }
                    }
                    catch (IOError iOError) {
                        // empty catch block
                    }
                    return answers;
                }
            });
            client.start();
            if (console != null) {
                console.printf("Logging in as %s\n", this.user);
            }
            ClientSession session = this.connect(client);
            if (this.password != null) {
                session.addPasswordIdentity(this.password);
            }
            session.auth().verify();
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter((Writer)writer, true);
            for (String location : locations) {
                print.println("bundle:install -s " + location);
            }
            ClientChannel channel = session.createChannel("exec", print.toString().concat(NEW_LINE));
            channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
            ByteArrayOutputStream sout = new ByteArrayOutputStream();
            ByteArrayOutputStream serr = new ByteArrayOutputStream();
            channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)sout));
            channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)serr));
            channel.open();
            channel.waitFor(2, 0L);
            sout.writeTo(System.out);
            serr.writeTo(System.err);
            boolean bl = isError = channel.getExitStatus() != null && channel.getExitStatus() != 0;
            if (isError) {
                String errorMarker = Ansi.ansi().fg(Ansi.Color.RED).toString();
                int fromIndex = sout.toString().indexOf(errorMarker) + errorMarker.length();
                int toIndex = sout.toString().lastIndexOf(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                throw new MojoExecutionException(NEW_LINE + sout.toString().substring(fromIndex, toIndex));
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MojoExecutionException((Object)t, t.getMessage(), t.toString());
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable t) {
                throw new MojoExecutionException((Object)t, t.getMessage(), t.toString());
            }
        }
    }

    private void setupAgent(String user, File keyFile, SshClient client) {
        URL builtInPrivateKey = ClientMojo.class.getClassLoader().getResource("karaf.key");
        SshAgent agent = this.startAgent(user, builtInPrivateKey, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SshAgent startAgent(String user, URL privateKeyUrl, File keyFile) {
        try (InputStream is = privateKeyUrl.openStream();){
            AgentImpl agent = new AgentImpl();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                String[] keyFiles = new String[]{keyFile.getAbsolutePath()};
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFiles);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            AgentImpl agentImpl = agent;
            return agentImpl;
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)("Error starting ssh agent for: " + e.getMessage()), e);
            return null;
        }
    }

    private ClientSession connect(SshClient client) throws IOException, InterruptedException {
        int retries = 0;
        ClientSession session = null;
        do {
            ConnectFuture future = client.connect(this.user, this.host, this.port);
            future.await();
            try {
                session = future.getSession();
            }
            catch (RuntimeSshException ex) {
                if (retries++ < this.attempts) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.delay));
                    this.getLog().info((CharSequence)("retrying (attempt " + retries + ") ..."));
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }
}

