/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jdbc.provider;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import javax.sql.DataSource;
import org.apache.karaf.examples.jdbc.api.Booking;
import org.apache.karaf.examples.jdbc.api.BookingService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.examples.jdbc.provider.bookingService", immediate=true)
public class BookingServiceJdbcImpl
implements BookingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BookingService.class);
    private static final String DATABASE_SCHEMA = "KARAF_EXAMPLE";
    private static final String[] createTableQueryDerbyTemplate = new String[]{"CREATE SCHEMA KARAF_EXAMPLE", "CREATE TABLE KARAF_EXAMPLE.BOOKING(id SMALLINT NOT NULL GENERATED BY DEFAULT AS IDENTITY  CONSTRAINT BOOKING_PK PRIMARY KEY, customer VARCHAR(200) NOT NULL, flight VARCHAR(100))"};
    private static final String selectBookingSql = "select id, customer, flight from KARAF_EXAMPLE.BOOKING";
    private static final String insertBookingSql = "insert into KARAF_EXAMPLE.BOOKING (customer, flight) values (?, ?)";
    private static final String updateBookingSql = "update KARAF_EXAMPLE.BOOKING set customer = ?, flight = ?where id = ?";
    private static final String deleteBookingSql = "delete from KARAF_EXAMPLE.BOOKING where id = ?";
    @Reference(target="(osgi.jndi.service.name=jdbc/karaf-example)")
    private DataSource dataSource;

    @Activate
    public void activate(ComponentContext context) {
        this.open(context.getProperties());
    }

    public void open(Dictionary<String, Object> config) {
        LOGGER.debug("Datasource {} ", (Object)this.dataSource);
        try (Connection connection = this.dataSource.getConnection();){
            this.createTables(connection);
        }
        catch (Exception e) {
            LOGGER.error("Error creating table ", (Throwable)e);
        }
    }

    private String getValue(Dictionary<String, Object> config, String key, String defaultValue) {
        String value = (String)config.get(key);
        return value != null ? value : defaultValue;
    }

    private void createTables(Connection connection) {
        block13: {
            try {
                DatabaseMetaData dbm = connection.getMetaData();
                ResultSet tables = dbm.getTables(null, DATABASE_SCHEMA, "BOOKING", null);
                if (!tables.next()) {
                    LOGGER.info("Tables does not exist");
                    String[] createTemplate = createTableQueryDerbyTemplate;
                    createTemplate = createTableQueryDerbyTemplate;
                    try (Statement createStatement = connection.createStatement();){
                        for (String s : createTemplate) {
                            createStatement.addBatch(s);
                        }
                        if (createStatement.executeBatch().length == 0) {
                            throw new SQLException("No table has been created !");
                        }
                        LOGGER.info("Schema and tables has been created");
                        break block13;
                    }
                    catch (SQLException exception) {
                        LOGGER.error("Can't create tables", (Throwable)exception);
                    }
                    break block13;
                }
                LOGGER.info("Tables already exist");
            }
            catch (SQLException exception) {
                LOGGER.error("Can't verify tables existence", (Throwable)exception);
            }
        }
    }

    public Collection<Booking> list() {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement selectStatement = connection.prepareStatement(selectBookingSql);){
                ResultSet rs = selectStatement.executeQuery();
                while (rs.next()) {
                    Booking booking = new Booking();
                    booking.setId(Long.valueOf(rs.getLong("id")));
                    booking.setCustomer(rs.getString("customer"));
                    booking.setFlight(rs.getString("flight"));
                    bookings.add(booking);
                }
            }
            catch (SQLException exception) {
                LOGGER.error("Can't retreive the bookings", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error getting connection ", (Throwable)exception);
        }
        return bookings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Booking get(Long id) {
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement selectStatement;
            block16: {
                String sqlQuery = "select id, customer, flight from KARAF_EXAMPLE.BOOKING where id = ?";
                try {
                    Booking booking;
                    selectStatement = connection.prepareStatement(sqlQuery);
                    try {
                        selectStatement.setLong(1, id);
                        ResultSet rs = selectStatement.executeQuery();
                        if (!rs.next()) break block16;
                        Booking booking2 = new Booking();
                        booking2.setId(id);
                        booking2.setCustomer(rs.getString("customer"));
                        booking2.setFlight(rs.getString("flight"));
                        booking = booking2;
                        if (selectStatement == null) return booking;
                    }
                    catch (Throwable throwable) {
                        if (selectStatement == null) throw throwable;
                        try {
                            selectStatement.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    selectStatement.close();
                    return booking;
                }
                catch (SQLException exception) {
                    LOGGER.error("Can't find booking with id {}", (Object)id, (Object)exception);
                    return null;
                }
            }
            if (selectStatement == null) return null;
            selectStatement.close();
            return null;
        }
        catch (Exception exception) {
            LOGGER.error("Error getting connection ", (Throwable)exception);
        }
        return null;
    }

    public void add(Booking booking) {
        try (Connection connection = this.dataSource.getConnection();){
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            try (PreparedStatement insertStatement = connection.prepareStatement(insertBookingSql, 1);){
                insertStatement.setString(1, booking.getCustomer());
                insertStatement.setString(2, booking.getFlight());
                insertStatement.executeUpdate();
                int newId = 0;
                ResultSet rs = insertStatement.getGeneratedKeys();
                if (rs.next()) {
                    newId = rs.getInt(1);
                }
                connection.commit();
                booking.setId(Long.valueOf(newId));
                LOGGER.debug("Booking created with id = {}", (Object)newId);
            }
            catch (SQLException exception) {
                connection.rollback();
                LOGGER.error("Can't insert booking with customer {}", (Object)booking.getCustomer(), (Object)exception);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error getting connection ", (Throwable)exception);
        }
    }

    public void remove(Long id) {
        try (Connection connection = this.dataSource.getConnection();){
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            try (PreparedStatement deleteStatement = connection.prepareStatement(deleteBookingSql);){
                deleteStatement.setInt(1, id.intValue());
                deleteStatement.executeUpdate();
                connection.commit();
                LOGGER.debug("Service deleted with id = {}", (Object)id);
            }
            catch (SQLException exception) {
                connection.rollback();
                LOGGER.error("Can't delete service with id {}", (Object)id, (Object)exception);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error getting connection ", (Throwable)exception);
        }
    }
}

