/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.graphql.websocket;

import graphql.ExecutionResult;
import graphql.GraphQL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@WebSocket
public class GraphQLWebSocketExample {
    private static final List<Session> sessions = new ArrayList<Session>();
    private final GraphQL graphQL;

    public GraphQLWebSocketExample(GraphQL graphQL) {
        this.graphQL = graphQL;
    }

    @OnWebSocketConnect
    public void onOpen(final Session session) {
        session.setIdleTimeout(-1L);
        sessions.add(session);
        String query = "    subscription BookFeed {\n        bookCreated {\n            id\n            name\n        }\n    }\n";
        ExecutionResult executionResult = this.graphQL.execute(query);
        Publisher bookStream = (Publisher)executionResult.getData();
        final AtomicReference subscriptionRef = new AtomicReference();
        bookStream.subscribe((Subscriber)new Subscriber<ExecutionResult>(){

            public void onSubscribe(Subscription subscription) {
                subscriptionRef.set(subscription);
                subscription.request(1L);
            }

            public void onNext(ExecutionResult executionResult) {
                try {
                    session.getRemote().sendString(executionResult.getData().toString());
                    ((Subscription)subscriptionRef.get()).request(1L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void onError(Throwable throwable) {
            }

            public void onComplete() {
            }
        });
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        sessions.remove(session);
    }
}

