/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.sink;

import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SinkRecordTest {
    private static final String TOPIC_NAME = "myTopic";
    private static final Integer PARTITION_NUMBER = 0;
    private static final long KAFKA_OFFSET = 0L;
    private static final Long KAFKA_TIMESTAMP = 0L;
    private static final TimestampType TS_TYPE = TimestampType.CREATE_TIME;
    private SinkRecord record;

    @Before
    public void beforeEach() {
        this.record = new SinkRecord(TOPIC_NAME, PARTITION_NUMBER.intValue(), Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, 0L, KAFKA_TIMESTAMP, TS_TYPE, null);
    }

    @Test
    public void shouldCreateSinkRecordWithHeaders() {
        Headers headers = new ConnectHeaders().addString("h1", "hv1").addBoolean("h2", true);
        this.record = new SinkRecord(TOPIC_NAME, PARTITION_NUMBER.intValue(), Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, 0L, KAFKA_TIMESTAMP, TS_TYPE, (Iterable)headers);
        Assert.assertNotNull((Object)this.record.headers());
        Assert.assertSame((Object)headers, (Object)this.record.headers());
        Assert.assertFalse((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldCreateSinkRecordWithEmptyHeaders() {
        Assert.assertEquals((Object)TOPIC_NAME, (Object)this.record.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)this.record.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)this.record.keySchema());
        Assert.assertEquals((Object)"key", (Object)this.record.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)this.record.valueSchema());
        Assert.assertEquals((Object)false, (Object)this.record.value());
        Assert.assertEquals((long)0L, (long)this.record.kafkaOffset());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)this.record.timestamp());
        Assert.assertEquals((Object)TS_TYPE, (Object)this.record.timestampType());
        Assert.assertNotNull((Object)this.record.headers());
        Assert.assertTrue((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldDuplicateRecordAndCloneHeaders() {
        SinkRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)duplicate.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assert.assertEquals((Object)"key", (Object)duplicate.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assert.assertEquals((Object)false, (Object)duplicate.value());
        Assert.assertEquals((long)0L, (long)duplicate.kafkaOffset());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)duplicate.timestamp());
        Assert.assertEquals((Object)TS_TYPE, (Object)duplicate.timestampType());
        Assert.assertNotNull((Object)duplicate.headers());
        Assert.assertTrue((boolean)duplicate.headers().isEmpty());
        Assert.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assert.assertEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldDuplicateRecordUsingNewHeaders() {
        Headers newHeaders = new ConnectHeaders().addString("h3", "hv3");
        SinkRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP, (Iterable)newHeaders);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)duplicate.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assert.assertEquals((Object)"key", (Object)duplicate.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assert.assertEquals((Object)false, (Object)duplicate.value());
        Assert.assertEquals((long)0L, (long)duplicate.kafkaOffset());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)duplicate.timestamp());
        Assert.assertEquals((Object)TS_TYPE, (Object)duplicate.timestampType());
        Assert.assertNotNull((Object)duplicate.headers());
        Assert.assertEquals((Object)newHeaders, (Object)duplicate.headers());
        Assert.assertSame((Object)newHeaders, (Object)duplicate.headers());
        Assert.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assert.assertNotEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldModifyRecordHeader() {
        Assert.assertTrue((boolean)this.record.headers().isEmpty());
        this.record.headers().addInt("intHeader", 100);
        Assert.assertEquals((long)1L, (long)this.record.headers().size());
        Header header = this.record.headers().lastWithName("intHeader");
        Assert.assertEquals((long)100L, (long)Values.convertToInteger((Schema)header.schema(), (Object)header.value()).intValue());
    }
}

