/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.util.ConnectorUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConnectorUtilsTest {
    private static final List<Integer> FIVE_ELEMENTS = Arrays.asList(1, 2, 3, 4, 5);

    @Test
    public void testGroupPartitions() {
        List grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)1);
        Assert.assertEquals(Arrays.asList(FIVE_ELEMENTS), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)2);
        Assert.assertEquals(Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)3);
        Assert.assertEquals(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4), Arrays.asList(5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)5);
        Assert.assertEquals(Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(3), Arrays.asList(4), Arrays.asList(5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)7);
        Assert.assertEquals(Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(3), Arrays.asList(4), Arrays.asList(5), Collections.EMPTY_LIST, Collections.EMPTY_LIST), (Object)grouped);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGroupPartitionsInvalidCount() {
        ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)0);
    }
}

