/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.SchemaBuilderException;
import org.junit.Assert;
import org.junit.Test;

public class SchemaBuilderTest {
    private static final String NAME = "name";
    private static final Integer VERSION = 2;
    private static final String DOC = "doc";
    private static final Map<String, String> NO_PARAMS = null;

    @Test
    public void testInt8Builder() {
        Schema schema = SchemaBuilder.int8().build();
        this.assertTypeAndDefault(schema, Schema.Type.INT8, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.int8().name(NAME).optional().defaultValue((Object)12).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.INT8, true, (byte)12);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testInt8BuilderInvalidDefault() {
        SchemaBuilder.int8().defaultValue((Object)"invalid");
    }

    @Test
    public void testInt16Builder() {
        Schema schema = SchemaBuilder.int16().build();
        this.assertTypeAndDefault(schema, Schema.Type.INT16, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.int16().name(NAME).optional().defaultValue((Object)12).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.INT16, true, (short)12);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testInt16BuilderInvalidDefault() {
        SchemaBuilder.int16().defaultValue((Object)"invalid");
    }

    @Test
    public void testInt32Builder() {
        Schema schema = SchemaBuilder.int32().build();
        this.assertTypeAndDefault(schema, Schema.Type.INT32, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.int32().name(NAME).optional().defaultValue((Object)12).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.INT32, true, 12);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testInt32BuilderInvalidDefault() {
        SchemaBuilder.int32().defaultValue((Object)"invalid");
    }

    @Test
    public void testInt64Builder() {
        Schema schema = SchemaBuilder.int64().build();
        this.assertTypeAndDefault(schema, Schema.Type.INT64, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.int64().name(NAME).optional().defaultValue((Object)12L).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.INT64, true, 12L);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testInt64BuilderInvalidDefault() {
        SchemaBuilder.int64().defaultValue((Object)"invalid");
    }

    @Test
    public void testFloatBuilder() {
        Schema schema = SchemaBuilder.float32().build();
        this.assertTypeAndDefault(schema, Schema.Type.FLOAT32, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.float32().name(NAME).optional().defaultValue((Object)Float.valueOf(12.0f)).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.FLOAT32, true, Float.valueOf(12.0f));
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testFloatBuilderInvalidDefault() {
        SchemaBuilder.float32().defaultValue((Object)"invalid");
    }

    @Test
    public void testDoubleBuilder() {
        Schema schema = SchemaBuilder.float64().build();
        this.assertTypeAndDefault(schema, Schema.Type.FLOAT64, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.float64().name(NAME).optional().defaultValue((Object)12.0).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.FLOAT64, true, 12.0);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testDoubleBuilderInvalidDefault() {
        SchemaBuilder.float64().defaultValue((Object)"invalid");
    }

    @Test
    public void testBooleanBuilder() {
        Schema schema = SchemaBuilder.bool().build();
        this.assertTypeAndDefault(schema, Schema.Type.BOOLEAN, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.bool().name(NAME).optional().defaultValue((Object)true).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.BOOLEAN, true, true);
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testBooleanBuilderInvalidDefault() {
        SchemaBuilder.bool().defaultValue((Object)"invalid");
    }

    @Test
    public void testStringBuilder() {
        Schema schema = SchemaBuilder.string().build();
        this.assertTypeAndDefault(schema, Schema.Type.STRING, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.string().name(NAME).optional().defaultValue((Object)"a default string").version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.STRING, true, "a default string");
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testStringBuilderInvalidDefault() {
        SchemaBuilder.string().defaultValue((Object)true);
    }

    @Test
    public void testBytesBuilder() {
        Schema schema = SchemaBuilder.bytes().build();
        this.assertTypeAndDefault(schema, Schema.Type.BYTES, false, null);
        this.assertNoMetadata(schema);
        schema = SchemaBuilder.bytes().name(NAME).optional().defaultValue((Object)"a default byte array".getBytes()).version(VERSION).doc(DOC).build();
        this.assertTypeAndDefault(schema, Schema.Type.BYTES, true, "a default byte array".getBytes());
        this.assertMetadata(schema, NAME, VERSION, DOC, NO_PARAMS);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testBytesBuilderInvalidDefault() {
        SchemaBuilder.bytes().defaultValue((Object)"a string, not bytes");
    }

    @Test
    public void testParameters() {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("foo", "val");
        expectedParameters.put("bar", "baz");
        Schema schema = SchemaBuilder.string().parameter("foo", "val").parameter("bar", "baz").build();
        this.assertTypeAndDefault(schema, Schema.Type.STRING, false, null);
        this.assertMetadata(schema, null, null, null, expectedParameters);
        schema = SchemaBuilder.string().parameters(expectedParameters).build();
        this.assertTypeAndDefault(schema, Schema.Type.STRING, false, null);
        this.assertMetadata(schema, null, null, null, expectedParameters);
    }

    @Test
    public void testStructBuilder() {
        Schema schema = SchemaBuilder.struct().field("field1", Schema.INT8_SCHEMA).field("field2", Schema.INT8_SCHEMA).build();
        this.assertTypeAndDefault(schema, Schema.Type.STRUCT, false, null);
        Assert.assertEquals((long)2L, (long)schema.fields().size());
        Assert.assertEquals((Object)"field1", (Object)((Field)schema.fields().get(0)).name());
        Assert.assertEquals((long)0L, (long)((Field)schema.fields().get(0)).index());
        Assert.assertEquals((Object)Schema.INT8_SCHEMA, (Object)((Field)schema.fields().get(0)).schema());
        Assert.assertEquals((Object)"field2", (Object)((Field)schema.fields().get(1)).name());
        Assert.assertEquals((long)1L, (long)((Field)schema.fields().get(1)).index());
        Assert.assertEquals((Object)Schema.INT8_SCHEMA, (Object)((Field)schema.fields().get(1)).schema());
        this.assertNoMetadata(schema);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testNonStructCantHaveFields() {
        SchemaBuilder.int8().field("field", SchemaBuilder.int8().build());
    }

    @Test
    public void testArrayBuilder() {
        Schema schema = SchemaBuilder.array((Schema)Schema.INT8_SCHEMA).build();
        this.assertTypeAndDefault(schema, Schema.Type.ARRAY, false, null);
        Assert.assertEquals((Object)schema.valueSchema(), (Object)Schema.INT8_SCHEMA);
        this.assertNoMetadata(schema);
        List<Byte> defArray = Arrays.asList((byte)1, (byte)2);
        schema = SchemaBuilder.array((Schema)Schema.INT8_SCHEMA).defaultValue(defArray).build();
        this.assertTypeAndDefault(schema, Schema.Type.ARRAY, false, defArray);
        Assert.assertEquals((Object)schema.valueSchema(), (Object)Schema.INT8_SCHEMA);
        this.assertNoMetadata(schema);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testArrayBuilderInvalidDefault() {
        SchemaBuilder.array((Schema)Schema.INT8_SCHEMA).defaultValue(Arrays.asList("string")).build();
    }

    @Test
    public void testMapBuilder() {
        SchemaBuilder schema = SchemaBuilder.map((Schema)Schema.INT8_SCHEMA, (Schema)Schema.INT8_SCHEMA);
        this.assertTypeAndDefault((Schema)schema, Schema.Type.MAP, false, null);
        Assert.assertEquals((Object)schema.keySchema(), (Object)Schema.INT8_SCHEMA);
        Assert.assertEquals((Object)schema.valueSchema(), (Object)Schema.INT8_SCHEMA);
        this.assertNoMetadata((Schema)schema);
        schema = SchemaBuilder.map((Schema)Schema.INT8_SCHEMA, (Schema)Schema.INT8_SCHEMA).build();
        this.assertTypeAndDefault((Schema)schema, Schema.Type.MAP, false, null);
        Assert.assertEquals((Object)schema.keySchema(), (Object)Schema.INT8_SCHEMA);
        Assert.assertEquals((Object)schema.valueSchema(), (Object)Schema.INT8_SCHEMA);
        this.assertNoMetadata((Schema)schema);
        Map<Byte, Byte> defMap = Collections.singletonMap((byte)5, (byte)10);
        schema = SchemaBuilder.map((Schema)Schema.INT8_SCHEMA, (Schema)Schema.INT8_SCHEMA).defaultValue(defMap).build();
        this.assertTypeAndDefault((Schema)schema, Schema.Type.MAP, false, defMap);
        Assert.assertEquals((Object)schema.keySchema(), (Object)Schema.INT8_SCHEMA);
        Assert.assertEquals((Object)schema.valueSchema(), (Object)Schema.INT8_SCHEMA);
        this.assertNoMetadata((Schema)schema);
    }

    @Test(expected=SchemaBuilderException.class)
    public void testMapBuilderInvalidDefault() {
        Map<Byte, String> defMap = Collections.singletonMap((byte)5, "foo");
        SchemaBuilder.map((Schema)Schema.INT8_SCHEMA, (Schema)Schema.INT8_SCHEMA).defaultValue(defMap).build();
    }

    private void assertTypeAndDefault(Schema schema, Schema.Type type, boolean optional, Object defaultValue) {
        Assert.assertEquals((Object)type, (Object)schema.type());
        Assert.assertEquals((Object)optional, (Object)schema.isOptional());
        if (type == Schema.Type.BYTES) {
            if (defaultValue == null) {
                Assert.assertNull((Object)schema.defaultValue());
            } else {
                Assert.assertEquals((Object)ByteBuffer.wrap((byte[])defaultValue), (Object)ByteBuffer.wrap((byte[])schema.defaultValue()));
            }
        } else {
            Assert.assertEquals((Object)defaultValue, (Object)schema.defaultValue());
        }
    }

    private void assertMetadata(Schema schema, String name, Integer version, String doc, Map<String, String> parameters) {
        Assert.assertEquals((Object)name, (Object)schema.name());
        Assert.assertEquals((Object)version, (Object)schema.version());
        Assert.assertEquals((Object)doc, (Object)schema.doc());
        Assert.assertEquals(parameters, (Object)schema.parameters());
    }

    private void assertNoMetadata(Schema schema) {
        this.assertMetadata(schema, null, null, null, null);
    }
}

