/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.mapping.wadl.Application;
import org.apache.juddi.v3.client.mapping.wadl.WADL2UDDI;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class WadlImport {
    private Properties properties = new Properties();
    private UDDISecurityPortType security = null;
    private UDDIPublicationPortType publish = null;

    public void fire(String pathOrURL, String businessKey, String token, Transport transport) throws Exception {
        int i;
        if (transport == null) {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            transport = clerkManager.getTransport();
        }
        this.security = transport.getUDDISecurityService();
        this.publish = transport.getUDDIPublishService();
        if (token == null) {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID("uddi");
            getAuthTokenRoot.setCred("uddi");
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            token = rootAuthToken.getAuthInfo();
        }
        Application app = null;
        if (!pathOrURL.startsWith("http")) {
            File f = new File("test.wadl");
            if (!f.exists()) {
                System.out.println(pathOrURL + " doesn't exist!");
                return;
            }
            System.out.println("Attempting to parse " + f.getAbsolutePath());
            app = WADL2UDDI.parseWadl((File)f);
        } else {
            app = WADL2UDDI.parseWadl((URL)new URL(pathOrURL));
        }
        List urls = WADL2UDDI.getBaseAddresses((Application)app);
        URL url = (URL)urls.get(0);
        String domain = url.getHost();
        PrintUDDI tmodelPrinter = new PrintUDDI();
        TModel keygen = UDDIClerk.createKeyGenator((String)("uddi:" + domain + ":keygenerator"), (String)domain, (String)"en");
        SaveTModel stm = new SaveTModel();
        stm.setAuthInfo(token);
        stm.getTModel().add(keygen);
        System.out.println("Saving the following tModel keygen");
        System.out.println(tmodelPrinter.print((Object)keygen));
        this.publish.saveTModel(stm);
        this.properties.put("keyDomain", domain);
        this.properties.put("businessName", domain);
        this.properties.put("serverName", url.getHost());
        this.properties.put("serverPort", (Object)url.getPort());
        WADL2UDDI wadl2UDDI = new WADL2UDDI(null, (URLLocalizer)new URLLocalizerDefaultImpl(), this.properties);
        BusinessService businessServices = wadl2UDDI.createBusinessService(new QName(domain, domain), app);
        Set portTypeTModels = wadl2UDDI.createWADLPortTypeTModels(pathOrURL, app);
        stm = new SaveTModel();
        stm.setAuthInfo(token);
        TModel[] tmodels = portTypeTModels.toArray(new TModel[0]);
        for (i = 0; i < tmodels.length; ++i) {
            System.out.println(tmodelPrinter.print((Object)tmodels[i]));
            stm.getTModel().add(tmodels[i]);
        }
        tmodels = wadl2UDDI.createWADLTModels(pathOrURL, app).toArray(new TModel[0]);
        for (i = 0; i < tmodels.length; ++i) {
            System.out.println(tmodelPrinter.print((Object)tmodels[i]));
            stm.getTModel().add(tmodels[i]);
        }
        System.out.println("Saving the following tModels " + stm.getTModel().size());
        this.publish.saveTModel(stm);
        PrintUDDI servicePrinter = new PrintUDDI();
        System.out.println("here's our new service: " + servicePrinter.print((Object)businessServices));
        if (businessKey == null || businessKey.length() == 0) {
            BusinessEntity be = new BusinessEntity();
            be.setBusinessKey(businessServices.getBusinessKey());
            be.getName().add(new Name());
            ((Name)be.getName().get(0)).setValue(domain);
            ((Name)be.getName().get(0)).setLang("en");
            be.setBusinessServices(new BusinessServices());
            be.getBusinessServices().getBusinessService().add(businessServices);
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(token);
            sb.getBusinessEntity().add(be);
            BusinessDetail saveBusiness = this.publish.saveBusiness(sb);
            System.out.println("new business created, key = " + ((BusinessEntity)saveBusiness.getBusinessEntity().get(0)).getBusinessKey());
        }
        SaveService ss = new SaveService();
        ss.setAuthInfo(token);
        businessServices.setBusinessKey(businessKey);
        ss.getBusinessService().add(businessServices);
        this.publish.saveService(ss);
        System.out.println("Saved! " + businessServices.getServiceKey());
    }

    public static void main(String[] args) throws Exception {
        new WadlImport().fire("http://svn.apache.org/repos/asf/cxf/trunk/systests/jaxrs/src/test/resources/wadl/bookstoreImportResource.wadl", null, null, null);
    }
}

