/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import javax.xml.datatype.DatatypeFactory;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.subscription.ISubscriptionCallback;
import org.apache.juddi.v3.client.subscription.SubscriptionCallbackListener;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModel;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.sub_v3.SubscriptionResultsList;

public class UddiSubscribe
implements ISubscriptionCallback {
    private UDDIClerk clerk = null;
    private UDDIClient client = null;
    private String nodename = "default";
    private PrintUDDI<SubscriptionResultsList> printer = new PrintUDDI();

    public static void main(String[] args) throws Exception {
        UddiSubscribe sp = new UddiSubscribe();
        sp.fire();
    }

    public UddiSubscribe() {
        try {
            this.client = new UDDIClient("META-INF/simple-publish-uddi.xml");
            this.clerk = this.client.getClerk("default");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UddiSubscribe(UDDIClient client, String nodename, Transport transport) {
        try {
            this.clerk = client.getClerk(nodename);
            this.nodename = nodename;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fire() throws Exception {
        TModel createKeyGenator = UDDIClerk.createKeyGenator((String)"somebusiness", (String)"A test key domain SubscriptionCallbackTest1", (String)"SubscriptionCallbackTest1");
        this.clerk.register(createKeyGenator);
        System.out.println("Registered tModel keygen: " + createKeyGenator.getTModelKey());
        BusinessEntity be = new BusinessEntity();
        be.setBusinessKey("uddi:somebusiness:somebusinesskey");
        be.getName().add(new Name("somebusiness SubscriptionCallbackTest1", null));
        be.setBusinessServices(new BusinessServices());
        BusinessService bs = new BusinessService();
        bs.setBusinessKey("uddi:somebusiness:somebusinesskey");
        bs.setServiceKey("uddi:somebusiness:someservicekey");
        bs.getName().add(new Name("service SubscriptionCallbackTest1", null));
        be.getBusinessServices().getBusinessService().add(bs);
        BusinessEntity register = this.clerk.register(be);
        System.out.println("Registered business keygen: " + register.getBusinessKey());
        BindingTemplate start = SubscriptionCallbackListener.start((UDDIClient)this.client, (String)this.nodename);
        SubscriptionCallbackListener.registerCallback((ISubscriptionCallback)this);
        Subscription sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setFindBusiness(new FindBusiness());
        sub.getSubscriptionFilter().getFindBusiness().setFindQualifiers(new FindQualifiers());
        sub.getSubscriptionFilter().getFindBusiness().getFindQualifiers().getFindQualifier().add("approximateMatch");
        sub.getSubscriptionFilter().getFindBusiness().getName().add(new Name("%", null));
        Subscription subscriptionBiz = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered FindBusiness subscription key: " + subscriptionBiz.getSubscriptionKey() + " bindingkey: " + subscriptionBiz.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setFindService(new FindService());
        sub.getSubscriptionFilter().getFindService().setFindQualifiers(new FindQualifiers());
        sub.getSubscriptionFilter().getFindService().getFindQualifiers().getFindQualifier().add("approximateMatch");
        sub.getSubscriptionFilter().getFindService().getName().add(new Name("%", null));
        Subscription subscriptionSvc = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered FindService subscription key: " + subscriptionSvc.getSubscriptionKey() + " bindingkey: " + subscriptionSvc.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setFindTModel(new FindTModel());
        sub.getSubscriptionFilter().getFindTModel().setFindQualifiers(new FindQualifiers());
        sub.getSubscriptionFilter().getFindTModel().getFindQualifiers().getFindQualifier().add("approximateMatch");
        sub.getSubscriptionFilter().getFindTModel().setName(new Name("%", null));
        Subscription subscriptionTM = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered FindTModel subscription key: " + subscriptionTM.getSubscriptionKey() + " bindingkey: " + subscriptionTM.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setGetAssertionStatusReport(new GetAssertionStatusReport());
        sub.getSubscriptionFilter().getGetAssertionStatusReport().setCompletionStatus(CompletionStatus.STATUS_COMPLETE);
        Subscription subscriptionPA = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered Completed PublisherAssertion subscription key: " + subscriptionPA.getSubscriptionKey() + " bindingkey: " + subscriptionTM.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setGetAssertionStatusReport(new GetAssertionStatusReport());
        sub.getSubscriptionFilter().getGetAssertionStatusReport().setCompletionStatus(CompletionStatus.STATUS_FROM_KEY_INCOMPLETE);
        Subscription subscriptionPA2 = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered FROM incomplete PublisherAssertion subscription key: " + subscriptionPA2.getSubscriptionKey() + " bindingkey: " + subscriptionTM.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setGetAssertionStatusReport(new GetAssertionStatusReport());
        sub.getSubscriptionFilter().getGetAssertionStatusReport().setCompletionStatus(CompletionStatus.STATUS_TO_KEY_INCOMPLETE);
        Subscription subscriptionPA3 = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered TO incomplete PublisherAssertion subscription key: " + subscriptionPA3.getSubscriptionKey() + " bindingkey: " + subscriptionTM.getBindingKey());
        sub = new Subscription();
        sub.setNotificationInterval(DatatypeFactory.newInstance().newDuration(1000L));
        sub.setBindingKey(start.getBindingKey());
        sub.setSubscriptionFilter(new SubscriptionFilter());
        sub.getSubscriptionFilter().setGetAssertionStatusReport(new GetAssertionStatusReport());
        sub.getSubscriptionFilter().getGetAssertionStatusReport().setCompletionStatus(CompletionStatus.STATUS_BOTH_INCOMPLETE);
        Subscription subscriptionPA4 = this.clerk.register(sub, this.clerk.getUDDINode().getApiNode());
        System.out.println("Registered recently deleted PublisherAssertion subscription key: " + subscriptionPA4.getSubscriptionKey() + " bindingkey: " + subscriptionTM.getBindingKey());
        System.out.println("Waiting for callbacks. Now would be a good time to launch either another program or juddi-gui to make some changes. Press any key to stop!");
        System.in.read();
        SubscriptionCallbackListener.stop((UDDIClient)this.client, (String)this.nodename, (String)start.getBindingKey());
        this.clerk.unRegisterSubscription(subscriptionBiz.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionSvc.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionTM.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionPA.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionPA2.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionPA3.getSubscriptionKey());
        this.clerk.unRegisterSubscription(subscriptionPA4.getSubscriptionKey());
        this.clerk.unRegisterTModel(createKeyGenator.getTModelKey());
        this.clerk.unRegisterBusiness("uddi:somebusiness:somebusinesskey");
    }

    public void handleCallback(SubscriptionResultsList body) {
        System.out.println("Callback received!");
        System.out.println(this.printer.print((Object)body));
    }

    public void notifyEndpointStopped() {
        System.out.println("The endpoint was stopped!");
    }
}

