/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.OutputStream;
import javax.xml.bind.JAXB;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiGetServiceDetails {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;

    public UddiGetServiceDetails() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fire(String token, String key) {
        if (key == null) {
            System.out.println("No key provided!");
            return;
        }
        try {
            if (token == null) {
                GetAuthToken getAuthTokenRoot = new GetAuthToken();
                getAuthTokenRoot.setUserID("root");
                getAuthTokenRoot.setCred("root");
                AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
                System.out.println("root AUTHTOKEN = don't log auth tokens!");
                token = rootAuthToken.getAuthInfo();
            }
            GetServiceDetail fs = new GetServiceDetail();
            fs.setAuthInfo(token);
            fs.getServiceKey().add(key);
            ServiceDetail serviceDetail = this.inquiry.getServiceDetail(fs);
            if (serviceDetail == null || serviceDetail.getBusinessService().isEmpty()) {
                System.out.println("mykey is not registered");
            } else {
                JAXB.marshal((Object)serviceDetail, (OutputStream)System.out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiGetServiceDetails sp = new UddiGetServiceDetails();
        sp.fire(null, "uddi:juddi.apache.org:services-inquiry");
    }
}

