/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.List;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiDigitalSignatureSearch {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;

    public UddiDigitalSignatureSearch() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiDigitalSignatureSearch sp = new UddiDigitalSignatureSearch();
        sp.fire(null);
    }

    public void fire(String token) {
        try {
            FindService fs = new FindService();
            if (token == null) {
                token = this.GetAuthKey("root", "root");
            }
            fs.setAuthInfo(token);
            fs.setFindQualifiers(new FindQualifiers());
            fs.getFindQualifiers().getFindQualifier().add("sortByDateAsc");
            fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
            fs.getFindQualifiers().getFindQualifier().add("signaturePresent");
            Name n = new Name();
            n.setValue("%");
            fs.getName().add(n);
            ServiceList findService = this.inquiry.findService(fs);
            if (findService != null && findService.getServiceInfos() != null) {
                for (int i = 0; i < findService.getServiceInfos().getServiceInfo().size(); ++i) {
                    System.out.println(this.listToString(((ServiceInfo)findService.getServiceInfos().getServiceInfo().get(i)).getName()));
                }
            } else {
                System.out.println("no results found.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String GetAuthKey(String username, String password) {
        try {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID(username);
            getAuthTokenRoot.setCred(password);
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            System.out.println("root AUTHTOKEN = dont log auth tokens!");
            return rootAuthToken.getAuthInfo();
        }
        catch (Exception ex) {
            System.out.println("Could not authenticate with the provided credentials " + ex.getMessage());
            return null;
        }
    }

    private String listToString(List<Name> name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            sb.append(name.get(i).getValue()).append(" ");
        }
        return sb.toString();
    }
}

