/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.jsonb;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.johnzon.websocket.internal.TypeAwareDecoder;
import org.apache.johnzon.websocket.jsonb.JsonbLocatorDelegate;

public class JsonbTextDecoder
extends TypeAwareDecoder
implements Decoder.TextStream<Object> {
    protected Jsonb mapper;
    protected Type type;

    public JsonbTextDecoder() {
    }

    public JsonbTextDecoder(Type type) {
        this(null, type);
    }

    public JsonbTextDecoder(Jsonb jsonb, Type type) {
        super(type);
        this.mapper = jsonb;
    }

    public Object decode(Reader stream) throws DecodeException {
        try {
            return this.mapper.fromJson(stream, this.type);
        }
        catch (JsonbException je) {
            throw new DecodeException("", je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public void init(EndpointConfig endpointConfig) {
        if (this.mapper == null) {
            this.mapper = JsonbLocatorDelegate.locate();
        }
        super.init(endpointConfig);
    }

    public void destroy() {
    }
}

