/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.StringUtil;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueReference<K, V>> myMap;
    protected final ReferenceQueue<V> myQueue;

    public ConcurrentRefValueHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(0);
        }
        this();
        this.putAll(map);
    }

    public ConcurrentRefValueHashMap() {
        this.myQueue = new ReferenceQueue();
        this.myMap = new ConcurrentHashMap<K, ValueReference<K, V>>();
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.myQueue = new ReferenceQueue();
        this.myMap = new ConcurrentHashMap<K, ValueReference<K, V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    boolean processQueue() {
        ValueReference ref;
        boolean processed = false;
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(@NotNull Object key) {
        ValueReference ref;
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(1);
        }
        if ((ref = (ValueReference)this.myMap.get(key)) == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(3);
        }
        this.processQueue();
        ValueReference<K, V> oldRef = this.myMap.put(key, this.createValueReference(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @NotNull
    protected abstract ValueReference<K, V> createValueReference(@NotNull K var1, @NotNull V var2);

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block4: {
            ValueReference<K, V> oldRef;
            if (key == null) {
                ConcurrentRefValueHashMap.$$$reportNull$$$0(4);
            }
            if (value == null) {
                ConcurrentRefValueHashMap.$$$reportNull$$$0(5);
            }
            ValueReference<K, V> newRef = this.createValueReference(key, value);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block4;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(6);
        }
        if (value == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(7);
        }
        this.processQueue();
        return this.myMap.remove(key, this.createValueReference(key, value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(8);
        }
        if (oldValue == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(9);
        }
        if (newValue == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(10);
        }
        this.processQueue();
        return this.myMap.replace(key, this.createValueReference(key, oldValue), this.createValueReference(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(11);
        }
        if (value == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(12);
        }
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.replace(key, this.createValueReference(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(13);
        }
        this.processQueue();
        ValueReference ref = (ValueReference)this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(14);
        }
        this.processQueue();
        for (Map.Entry<K, V> entry : t.entrySet()) {
            V v = entry.getValue();
            if (v == null) continue;
            K key = entry.getKey();
            this.put(key, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(15);
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        if (value == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myMap.keySet();
        if (set == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(@NotNull V value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new UnsupportedOperationException("setValue is not implemented");
                }

                public String toString() {
                    return "(" + this.getKey() + " : " + this.getValue() + ")";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/bulenkov/iconloader/util/ConcurrentRefValueHashMap$1", "setValue"));
                }
            });
        }
        HashSet<Map.Entry<K, V>> hashSet = entries;
        if (hashSet == null) {
            ConcurrentRefValueHashMap.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    public String toString() {
        return "map size:" + this.size() + " [" + StringUtil.join(this.entrySet(), ",") + "]";
    }

    int underlyingMapSize() {
        return this.myMap.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/bulenkov/iconloader/util/ConcurrentRefValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/bulenkov/iconloader/util/ConcurrentRefValueHashMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public K getKey();

        public V get();
    }
}

