/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class DarculaInternalFrameUI
extends BasicInternalFrameUI {
    public DarculaInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaInternalFrameUI((JInternalFrame)c);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new BasicInternalFrameTitlePane(w){

            @Override
            protected void installDefaults() {
                super.installDefaults();
                this.closeIcon = new CloseIcon();
                this.maxIcon = new MaximizeIcon();
                this.minIcon = new MinimizeIcon();
                this.iconIcon = new IconifyIcon();
                this.selectedTitleColor = UIManager.getColor("InternalFrameTitlePane.darcula.selected.backgroundColor");
                this.selectedTextColor = UIManager.getColor("darcula.textForeground");
                this.notSelectedTitleColor = UIManager.getColor("InternalFrameTitlePane.darcula.backgroundColor");
                this.notSelectedTextColor = UIManager.getColor("darcula.textForeground");
            }

            @Override
            protected void createButtons() {
                super.createButtons();
                MouseAdapter listener = new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        Icon icon = ((JButton)e.getComponent()).getIcon();
                        if (icon instanceof FrameIcon) {
                            Color c = ((FrameIcon)icon).getColor();
                            ((FrameIcon)icon).setColor(c.brighter());
                            e.getComponent().repaint();
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        Icon icon = ((JButton)e.getComponent()).getIcon();
                        if (icon instanceof FrameIcon) {
                            ((FrameIcon)icon).setColor(UIManager.getColor("InternalFrameTitlePane.darcula.buttonColor"));
                            e.getComponent().repaint();
                        }
                    }
                };
                this.closeButton.setBorder(null);
                this.closeButton.setOpaque(false);
                this.closeButton.addMouseListener(listener);
                this.maxButton.setBorder(null);
                this.maxButton.setOpaque(false);
                this.maxButton.addMouseListener(listener);
                this.iconButton.setBorder(null);
                this.iconButton.setOpaque(false);
                this.iconButton.addMouseListener(listener);
            }

            @Override
            protected void paintBorder(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                Color top = UIManager.getColor("InternalFrameTitlePane.darcula.borderColorTop");
                Color left = UIManager.getColor("InternalFrameTitlePane.darcula.borderColorLeft");
                Color bottom = UIManager.getColor("InternalFrameTitlePane.darcula.borderColorBottom");
                if (this.frame.isSelected()) {
                    top = UIManager.getColor("InternalFrameTitlePane.darcula.selected.borderColorTop");
                    left = UIManager.getColor("InternalFrameTitlePane.darcula.selected.borderColorLeft");
                    bottom = UIManager.getColor("InternalFrameTitlePane.darcula.selected.borderColorBottom");
                }
                g.setColor(top);
                g.drawLine(2, 0, w, 0);
                g.setColor(left);
                g.drawLine(0, 1, 0, h);
                g.setColor(bottom);
                g.drawLine(2, h, w, h);
            }
        };
        this.titlePane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
        return this.titlePane;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    private static class IconifyIcon
    extends FrameIcon {
        public IconifyIcon() {
            this(UIManager.getColor("InternalFrameTitlePane.darcula.buttonColor"));
        }

        public IconifyIcon(Color c) {
            super(c);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setPaint(this.getColor());
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(4, 12, 12, 12);
            config.restore();
        }
    }

    private static class MinimizeIcon
    extends FrameIcon {
        public MinimizeIcon() {
            this(UIManager.getColor("InternalFrameTitlePane.darcula.buttonColor"));
        }

        public MinimizeIcon(Color c) {
            super(c);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setPaint(this.getColor());
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawRect(1, 5, 8, 8);
            g2.drawLine(4, 2, 12, 2);
            g2.drawLine(12, 3, 12, 10);
            config.restore();
        }
    }

    private static class MaximizeIcon
    extends FrameIcon {
        public MaximizeIcon() {
            this(UIManager.getColor("InternalFrameTitlePane.darcula.buttonColor"));
        }

        public MaximizeIcon(Color c) {
            super(c);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setPaint(this.getColor());
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawRect(3, 3, 10, 9);
            config.restore();
        }
    }

    private static class CloseIcon
    extends FrameIcon {
        public CloseIcon() {
            this(UIManager.getColor("InternalFrameTitlePane.darcula.buttonColor"));
        }

        public CloseIcon(Color c) {
            super(c);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setStroke(new BasicStroke(1.5f));
            g2.setPaint(this.getColor());
            g.drawLine(5, 4, 11, 10);
            g.drawLine(11, 4, 5, 10);
            config.restore();
        }
    }

    private static abstract class FrameIcon
    implements Icon {
        private Color mColor;

        public FrameIcon(Color c) {
            this.mColor = c;
        }

        public Color getColor() {
            return this.mColor;
        }

        public void setColor(Color c) {
            this.mColor = c;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

