/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.reflect.ClassFilter;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final int DOT_CLASS_LEN = ".class".length();

    private ClassFinder() {
    }

    public static List<String> findClassesThatExtend(String[] paths, Class<?>[] superClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        for (String path : paths) {
            String[] jars;
            fullList.add(path);
            File dir = new File(path);
            if (!dir.exists() || !dir.isDirectory() || (jars = dir.list((f, name) -> {
                File fileInDirectory = new File(f, name);
                return fileInDirectory.isFile() && name.endsWith(DOT_JAR);
            })) == null) continue;
            Collections.addAll(fullList, jars);
        }
        return fullList.toArray(new String[fullList.size()]);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, null, null);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses, String contains, String notContains) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, contains, notContains, false);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, innerClasses, null, null, true);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, false, null, null, true);
    }

    public static List<String> findClassesThatExtend(String[] searchPathsOrJars, Class<?>[] classNames, boolean innerClasses, String contains, String notContains, boolean annotations) throws IOException {
        ClassFilter filter;
        if (log.isDebugEnabled()) {
            log.debug("findClassesThatExtend with searchPathsOrJars : {}, superclass : {} innerClasses : {} annotations: {} contains: {}, notContains: {}", new Object[]{Arrays.toString(searchPathsOrJars), Arrays.toString(classNames), innerClasses, annotations, contains, notContains});
        }
        if (annotations) {
            Class<?>[] annoclassNames = classNames;
            filter = new AnnoClassFilter(annoclassNames, innerClasses);
        } else {
            filter = new ExtendsClassFilter(classNames, innerClasses, contains, notContains);
        }
        return ClassFinder.findClasses(searchPathsOrJars, filter);
    }

    public static List<String> findClasses(String[] searchPathsOrJars, ClassFilter filter) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("findClasses with searchPathsOrJars : {} and classFilter : {}", (Object)Arrays.toString(searchPathsOrJars), (Object)filter);
        }
        List<String> strPathsOrJars = Arrays.stream(ClassFinder.addJarsInPath(searchPathsOrJars)).map(ClassFinder::fixPathEntry).collect(Collectors.toList());
        List<String> listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        if (log.isDebugEnabled()) {
            for (String path : listPaths) {
                log.debug("listPaths : {}", (Object)path);
            }
        }
        TreeSet<String> listClasses = new TreeSet<String>();
        for (String path : listPaths) {
            ClassFinder.findClassesInOnePath(path, listClasses, filter);
        }
        if (log.isDebugEnabled()) {
            log.debug("listClasses.size()={}", (Object)listClasses.size());
            for (String clazz : listClasses) {
                log.debug("listClasses : {}", (Object)clazz);
            }
        }
        return new ArrayList<String>(listClasses);
    }

    private static List<String> getClasspathMatches(List<String> strPathsOrJars) {
        String javaClassPath = System.getProperty("java.class.path");
        if (log.isDebugEnabled()) {
            log.debug("Classpath = {}", (Object)javaClassPath);
            for (int i = 0; i < strPathsOrJars.size(); ++i) {
                log.debug("strPathsOrJars[{}] : {}", (Object)i, (Object)strPathsOrJars.get(i));
            }
        }
        ArrayList<String> listPaths = new ArrayList<String>();
        StringTokenizer classpathElements = new StringTokenizer(javaClassPath, File.pathSeparator);
        while (classpathElements.hasMoreTokens()) {
            String classpathElement = ClassFinder.fixPathEntry(classpathElements.nextToken());
            if (classpathElement == null) continue;
            boolean found = false;
            for (String currentStrPathOrJar : strPathsOrJars) {
                log.debug("Testing if {}\u00a0ends with {}", (Object)classpathElement, (Object)currentStrPathOrJar);
                if (currentStrPathOrJar == null || !classpathElement.endsWith(currentStrPathOrJar)) continue;
                found = true;
                log.debug("Adding {}", (Object)classpathElement);
                listPaths.add(classpathElement);
                break;
            }
            if (found) continue;
            log.debug("Classpath element {} does not match any search path {}", (Object)classpathElement, strPathsOrJars);
        }
        return listPaths;
    }

    private static String fixPathEntry(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        String resultPath = path;
        if (path.length() > 3 && path.matches("[a-z]:\\\\.*")) {
            resultPath = path.substring(0, 1).toUpperCase(Locale.ROOT) + path.substring(1);
        }
        resultPath = resultPath.trim().replace('\\', '/');
        resultPath = JOrphanUtils.substitute(resultPath, "//", "/");
        while (resultPath.endsWith("/")) {
            resultPath = resultPath.substring(0, resultPath.length() - 1);
        }
        return resultPath;
    }

    private static String fixClassName(String strClassName) {
        String fixedClassName = strClassName.replace('\\', '.');
        fixedClassName = fixedClassName.replace('/', '.');
        fixedClassName = fixedClassName.substring(0, fixedClassName.length() - DOT_CLASS_LEN);
        return fixedClassName;
    }

    private static void findClassesInOnePath(String strPath, Set<String> listClasses, ClassFilter filter) throws IOException {
        File file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses, filter);
        } else if (file.exists()) {
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String fixedClassName;
                    String strEntry = entries.nextElement().toString();
                    if (!strEntry.endsWith(DOT_CLASS) || !filter.accept(fixedClassName = ClassFinder.fixClassName(strEntry))) continue;
                    listClasses.add(fixedClassName);
                }
            }
            catch (IOException e) {
                log.warn("Can not open the jar {}, message: {}", new Object[]{strPath, e.getLocalizedMessage(), e});
            }
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set<String> listClasses, ClassFilter filter) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            log.warn("{} is not a folder", (Object)dir.getAbsolutePath());
            return;
        }
        for (String filePath : list) {
            String path;
            String className;
            File file = new File(dir, filePath);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses, filter);
                continue;
            }
            if (!filePath.endsWith(DOT_CLASS) || !file.exists() || file.length() == 0L || !filter.accept(className = (path = file.getPath()).substring(strPathElement.length() + 1, path.lastIndexOf(46)).replace(File.separator.charAt(0), '.'))) continue;
            listClasses.add(className);
        }
    }

    private static class AnnoClassFilter
    implements ClassFilter {
        private final boolean inner;
        private final Class<? extends Annotation>[] annotations;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        AnnoClassFilter(Class<? extends Annotation>[] annotations, boolean inner) {
            this.annotations = annotations;
            this.inner = inner;
        }

        @Override
        public boolean accept(String className) {
            if (!className.contains("$") || this.inner) {
                return this.hasAnnotationOnMethod(this.annotations, className, this.contextClassLoader);
            }
            return false;
        }

        private boolean hasAnnotationOnMethod(Class<? extends Annotation>[] annotations, String classInQuestion, ClassLoader contextClassLoader) {
            try {
                Class<?> c = Class.forName(classInQuestion, false, contextClassLoader);
                return Arrays.stream(c.getMethods()).anyMatch(method -> Arrays.stream(annotations).anyMatch(method::isAnnotationPresent));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError ignored) {
                log.debug(ignored.getLocalizedMessage(), ignored);
                return false;
            }
        }

        public String toString() {
            return "AnnoClassFilter [inner=" + this.inner + ", annotations=" + (this.annotations != null ? Arrays.toString(this.annotations) : "null") + "]";
        }
    }

    private static class ExtendsClassFilter
    implements ClassFilter {
        private final Class<?>[] parents;
        private final boolean inner;
        private final String contains;
        private final String notContains;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        ExtendsClassFilter(Class<?>[] parents, boolean inner, String contains, String notContains) {
            this.parents = parents;
            this.inner = inner;
            this.contains = contains;
            this.notContains = notContains;
        }

        @Override
        public boolean accept(String className) {
            if (this.contains != null && !className.contains(this.contains)) {
                return false;
            }
            if (this.notContains != null && className.contains(this.notContains)) {
                return false;
            }
            if (!className.contains("$") || this.inner) {
                return this.isChildOf(this.parents, className, this.contextClassLoader);
            }
            return false;
        }

        private boolean isChildOf(Class<?>[] parentClasses, String strClassName, ClassLoader contextClassLoader) {
            try {
                Class<?> targetClass = Class.forName(strClassName, false, contextClassLoader);
                if (!targetClass.isInterface() && !Modifier.isAbstract(targetClass.getModifiers())) {
                    return Arrays.stream(parentClasses).anyMatch(parent -> parent.isAssignableFrom(targetClass));
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError e) {
                log.debug(e.getLocalizedMessage(), e);
            }
            return false;
        }

        public String toString() {
            return "ExtendsClassFilter [parents=" + (this.parents != null ? Arrays.toString(this.parents) : "null") + ", inner=" + this.inner + ", contains=" + this.contains + ", notContains=" + this.notContains + "]";
        }
    }
}

