/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart.axis.scale;

import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.PropertyException;

public class ChartScale {
    double yMax;
    double yMin;
    double yDelta = 0.0;
    double yStart = 0.0;
    double yEnd = 0.0;
    int rounding = 0;
    int segments = 20;

    public static void main(String[] stringArray) {
        ChartScale chartScale = new ChartScale();
        chartScale.yMin = -30.0;
        chartScale.yMax = 200.0;
        chartScale.calculate();
        System.out.println("yStart= " + chartScale.yStart + "  yEnd= " + chartScale.yEnd + "  segments= " + chartScale.segments + "  rounding= " + chartScale.rounding);
    }

    public ChartScale() {
    }

    public ChartScale(double[][] dArray) {
        this.yMax = this.getMax(dArray);
        this.yMin = this.getMin(dArray);
        this.calculate();
    }

    private void calculate() {
        this.yDelta = Math.pow(10.0, Math.round(Math.log(this.yMax - this.yMin) / Math.log(10.0)));
        this.yStart = this.yMin - this.yMin % this.yDelta;
        this.yEnd = this.yMax - this.yMax % this.yDelta + this.yDelta;
        this.segments = (int)((this.yEnd - this.yStart) / this.yDelta);
        if (this.segments <= 2) {
            this.yDelta /= 10.0;
        } else if (this.segments <= 5) {
            this.yDelta /= 4.0;
        } else if (this.segments <= 10) {
            this.yDelta /= 2.0;
        }
        this.yStart = this.yMin - this.yMin % this.yDelta;
        this.yEnd = this.yMax - this.yMax % this.yDelta + this.yDelta;
        this.segments = (int)((this.yEnd - this.yStart) / this.yDelta);
        this.rounding = (int)(Math.round(Math.log(this.yDelta) / Math.log(10.0)) - 3L);
    }

    private double getMax(double[][] dArray) {
        double d = Double.MIN_VALUE;
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            int n2 = 0;
            while (n2 < dArray2.length) {
                double d2 = dArray2[n2];
                if (d2 > d) {
                    d = d2;
                }
                ++n2;
            }
            ++n;
        }
        return d;
    }

    private double getMin(double[][] dArray) {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            int n2 = 0;
            while (n2 < dArray2.length) {
                double d2 = dArray2[n2];
                if (d2 < d) {
                    d = d2;
                }
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYDelta() {
        return this.yDelta;
    }

    public double getYStart() {
        return this.yStart;
    }

    public double getYEnd() {
        return this.yEnd;
    }

    public int getRounding() {
        return this.rounding;
    }

    public int getSegments() {
        return this.segments;
    }

    public AxisProperties getAxisProperties() throws PropertyException {
        return null;
    }
}

