/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsSameDay<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsSameDay(TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        if (!this.expected.isSameDay(actual)) {
            mismatchDesc.appendText("the day is " + this.describer.describeDate(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the same day as " + this.describer.describeDate(this.expected.unwrap()));
    }
}

