/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.lang.reflect.Constructor;
import org.apache.jmeter.samplers.AsynchSampleSender;
import org.apache.jmeter.samplers.BatchSampleSender;
import org.apache.jmeter.samplers.DataStrippingSampleSender;
import org.apache.jmeter.samplers.DiskStoreSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.StandardSampleSender;
import org.apache.jmeter.samplers.StatisticalSampleSender;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleSenderFactory {
    private static final Logger log = LoggerFactory.getLogger(SampleSenderFactory.class);
    private static final String MODE_STANDARD = "Standard";
    private static final String MODE_BATCH = "Batch";
    private static final String MODE_STATISTICAL = "Statistical";
    private static final String MODE_STRIPPED = "Stripped";
    private static final String MODE_STRIPPED_BATCH = "StrippedBatch";
    private static final String MODE_ASYNCH = "Asynch";
    private static final String MODE_STRIPPED_ASYNCH = "StrippedAsynch";
    private static final String MODE_DISKSTORE = "DiskStore";
    private static final String MODE_STRIPPED_DISKSTORE = "StrippedDiskStore";

    static SampleSender getInstance(RemoteSampleListener listener) {
        SampleSender s;
        String type = JMeterUtils.getPropDefault("mode", MODE_STRIPPED_BATCH);
        if (type.equalsIgnoreCase(MODE_BATCH)) {
            s = new BatchSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_STRIPPED_BATCH)) {
            s = new DataStrippingSampleSender(new BatchSampleSender(listener));
        } else if (type.equalsIgnoreCase(MODE_STATISTICAL)) {
            s = new StatisticalSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_STANDARD)) {
            s = new StandardSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_STRIPPED)) {
            s = new DataStrippingSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_ASYNCH)) {
            s = new AsynchSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_STRIPPED_ASYNCH)) {
            s = new DataStrippingSampleSender(new AsynchSampleSender(listener));
        } else if (type.equalsIgnoreCase(MODE_DISKSTORE)) {
            s = new DiskStoreSampleSender(listener);
        } else if (type.equalsIgnoreCase(MODE_STRIPPED_DISKSTORE)) {
            s = new DataStrippingSampleSender(new DiskStoreSampleSender(listener));
        } else {
            try {
                Class<?> clazz = Class.forName(type);
                Constructor<?> cons = clazz.getConstructor(RemoteSampleListener.class);
                s = (SampleSender)cons.newInstance(listener);
            }
            catch (Exception e) {
                log.error("Unable to create a sample sender from class:'{}', search for mode property in jmeter.properties for correct configuration options", (Object)type);
                throw new IllegalArgumentException("Unable to create a sample sender from mode or class:'" + type + "', search for mode property in jmeter.properties for correct configuration options, message:" + e.getMessage(), e);
            }
        }
        return s;
    }
}

