/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.StringConverter;

public final class Converters {
    private static final Map<Class<?>, StringConverter<?>> CONVERTER_MAP = new HashMap();

    private Converters() {
    }

    public static <T> StringConverter<T> getConverter(Class<T> clazz) {
        return CONVERTER_MAP.get(clazz);
    }

    public static <T> T convert(Class<T> clazz, String value) throws ConvertException {
        String result;
        if (clazz.isAssignableFrom(String.class)) {
            String temp;
            result = temp = value;
        } else {
            StringConverter<T> converter = Converters.getConverter(clazz);
            if (converter == null) {
                throw new ConvertException(value, clazz.getName());
            }
            result = converter.convert(value);
        }
        return (T)result;
    }

    static {
        StringConverter<Character> characterConverter = new StringConverter<Character>(){

            @Override
            public Character convert(String value) throws ConvertException {
                try {
                    return Character.valueOf(value.charAt(0));
                }
                catch (NumberFormatException ex) {
                    throw new ConvertException(value, Character.class.getName(), ex);
                }
            }
        };
        CONVERTER_MAP.put(Character.class, characterConverter);
        CONVERTER_MAP.put(Character.TYPE, characterConverter);
        StringConverter<Double> doubleConverter = new StringConverter<Double>(){

            @Override
            public Double convert(String value) throws ConvertException {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    throw new ConvertException(value, Double.class.getName(), ex);
                }
            }
        };
        CONVERTER_MAP.put(Double.class, doubleConverter);
        CONVERTER_MAP.put(Double.TYPE, doubleConverter);
        StringConverter<Float> floatConverter = new StringConverter<Float>(){

            @Override
            public Float convert(String value) throws ConvertException {
                try {
                    return Float.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    throw new ConvertException(value, Float.class.getName(), ex);
                }
            }
        };
        CONVERTER_MAP.put(Float.class, floatConverter);
        CONVERTER_MAP.put(Float.TYPE, floatConverter);
        StringConverter<Integer> integerConverter = new StringConverter<Integer>(){

            @Override
            public Integer convert(String value) throws ConvertException {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    throw new ConvertException(value, Integer.class.getName(), ex);
                }
            }
        };
        CONVERTER_MAP.put(Integer.class, integerConverter);
        CONVERTER_MAP.put(Integer.TYPE, integerConverter);
        StringConverter<Long> longConverter = new StringConverter<Long>(){

            @Override
            public Long convert(String value) throws ConvertException {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException ex) {
                    throw new ConvertException(value, Long.class.getName(), ex);
                }
            }
        };
        CONVERTER_MAP.put(Long.class, longConverter);
        CONVERTER_MAP.put(Long.TYPE, longConverter);
        StringConverter<Boolean> booleanConverter = new StringConverter<Boolean>(){

            @Override
            public Boolean convert(String value) {
                return Boolean.valueOf(value);
            }
        };
        CONVERTER_MAP.put(Boolean.class, booleanConverter);
        CONVERTER_MAP.put(Boolean.TYPE, booleanConverter);
        CONVERTER_MAP.put(File.class, new StringConverter<File>(){

            @Override
            public File convert(String value) throws ConvertException {
                return new File(value);
            }
        });
    }
}

