/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeNode;

public class ResetSearchCommand
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        try {
            guiPackage.beginUndoTransaction();
            guiPackage.getTreeModel().getNodesOfType(Searchable.class).stream().filter(node -> node.getUserObject() instanceof Searchable).map(JMeterTreeNode::getPathToThreadGroup).flatMap(Collection::stream).forEach(matchingNode -> matchingNode.setMarkedBySearch(false));
        }
        finally {
            guiPackage.endUndoTransaction();
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("search_reset");
    }
}

