/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.control.WhileController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=4)
public class WhileControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private static final String CONDITION_LABEL = "while_controller_label";
    private JSyntaxTextArea theCondition;
    private static final String CONDITION = "While_Condition";

    public WhileControllerGui() {
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof WhileController) {
            this.theCondition.setText(((WhileController)element).getCondition());
        }
    }

    @Override
    public TestElement createTestElement() {
        WhileController controller = new WhileController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof WhileController) {
            if (this.theCondition.getText().length() > 0) {
                ((WhileController)controller).setCondition(this.theCondition.getText());
            } else {
                ((WhileController)controller).setCondition("");
            }
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.theCondition.setText("");
    }

    @Override
    public String getLabelResource() {
        return "while_controller_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createConditionPanel(), "North");
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        JLabel conditionLabel = new JLabel(JMeterUtils.getResString(CONDITION_LABEL));
        conditionPanel.add((Component)conditionLabel, "West");
        this.theCondition = JSyntaxTextArea.getInstance(5, 50);
        this.theCondition.setName(CONDITION);
        conditionLabel.setLabelFor((Component)((Object)this.theCondition));
        conditionPanel.add((Component)((Object)JTextScrollPane.getInstance(this.theCondition)), "Center");
        conditionPanel.add(Box.createHorizontalGlue(), "North");
        return conditionPanel;
    }
}

