/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.UserMetric;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.TextGraphiteMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteBackendListenerClient
extends AbstractBackendListenerClient
implements Runnable {
    private static final String GRAPHITE_METRICS_SENDER = "graphiteMetricsSender";
    private static final String GRAPHITE_HOST = "graphiteHost";
    private static final String GRAPHITE_PORT = "graphitePort";
    private static final String ROOT_METRICS_PREFIX = "rootMetricsPrefix";
    private static final String PERCENTILES = "percentiles";
    private static final String SAMPLERS_LIST = "samplersList";
    public static final String USE_REGEXP_FOR_SAMPLERS_LIST = "useRegexpForSamplersList";
    public static final String USE_REGEXP_FOR_SAMPLERS_LIST_DEFAULT = "false";
    private static final String SUMMARY_ONLY = "summaryOnly";
    private static final int DEFAULT_PLAINTEXT_PROTOCOL_PORT = 2003;
    private static final String TEST_CONTEXT_NAME = "test";
    private static final String ALL_CONTEXT_NAME = "all";
    private static final Logger log = LoggerFactory.getLogger(GraphiteBackendListenerClient.class);
    private static final String DEFAULT_METRICS_PREFIX = "jmeter.";
    private static final String CUMULATED_METRICS = "__cumulated__";
    private static final String METRIC_MAX_ACTIVE_THREADS = "maxAT";
    private static final String METRIC_MIN_ACTIVE_THREADS = "minAT";
    private static final String METRIC_MEAN_ACTIVE_THREADS = "meanAT";
    private static final String METRIC_STARTED_THREADS = "startedT";
    private static final String METRIC_FINISHED_THREADS = "endedT";
    private static final String METRIC_SEPARATOR = ".";
    private static final String METRIC_OK_PREFIX = "ok";
    private static final String METRIC_KO_PREFIX = "ko";
    private static final String METRIC_ALL_PREFIX = "a";
    private static final String METRIC_HITS_PREFIX = "h";
    private static final String METRIC_COUNT = "count";
    private static final String METRIC_MIN_RESPONSE_TIME = "min";
    private static final String METRIC_MAX_RESPONSE_TIME = "max";
    private static final String METRIC_AVG_RESPONSE_TIME = "avg";
    private static final String METRIC_PERCENTILE = "pct";
    private static final String METRIC_OK_COUNT = "ok.count";
    private static final String METRIC_OK_MIN_RESPONSE_TIME = "ok.min";
    private static final String METRIC_OK_MAX_RESPONSE_TIME = "ok.max";
    private static final String METRIC_OK_AVG_RESPONSE_TIME = "ok.avg";
    private static final String METRIC_OK_PERCENTILE_PREFIX = "ok.pct";
    private static final String METRIC_KO_COUNT = "ko.count";
    private static final String METRIC_KO_MIN_RESPONSE_TIME = "ko.min";
    private static final String METRIC_KO_MAX_RESPONSE_TIME = "ko.max";
    private static final String METRIC_KO_AVG_RESPONSE_TIME = "ko.avg";
    private static final String METRIC_KO_PERCENTILE_PREFIX = "ko.pct";
    private static final String METRIC_ALL_COUNT = "a.count";
    private static final String METRIC_ALL_MIN_RESPONSE_TIME = "a.min";
    private static final String METRIC_ALL_MAX_RESPONSE_TIME = "a.max";
    private static final String METRIC_ALL_AVG_RESPONSE_TIME = "a.avg";
    private static final String METRIC_ALL_PERCENTILE_PREFIX = "a.pct";
    private static final String METRIC_ALL_HITS_COUNT = "h.count";
    private static final long SEND_INTERVAL = JMeterUtils.getPropDefault((String)"backend_graphite.send_interval", (int)1);
    private static final int MAX_POOL_SIZE = 1;
    private static final String DEFAULT_PERCENTILES = "90;95;99";
    private static final String SEPARATOR = ";";
    private static final Object LOCK = new Object();
    private String graphiteHost;
    private int graphitePort;
    private boolean summaryOnly;
    private String rootMetricsPrefix;
    private String samplersList = "";
    private boolean useRegexpForSamplersList;
    private Set<String> samplersToFilter;
    private Map<String, Float> okPercentiles;
    private Map<String, Float> koPercentiles;
    private Map<String, Float> allPercentiles;
    private GraphiteMetricsSender graphiteMetricsManager;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> timerHandle;
    private Pattern pattern;

    @Override
    public void run() {
        this.sendMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMetrics() {
        long timestampInSeconds = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<String, SamplerMetric> entry : this.getMetricsPerSampler().entrySet()) {
                String key = entry.getKey();
                SamplerMetric metric = entry.getValue();
                if (key.equals(CUMULATED_METRICS)) {
                    this.addMetrics(timestampInSeconds, ALL_CONTEXT_NAME, metric);
                } else {
                    this.addMetrics(timestampInSeconds, AbstractGraphiteMetricsSender.sanitizeString(key), metric);
                }
                metric.resetForTimeInterval();
            }
        }
        UserMetric userMetric = this.getUserMetrics();
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MIN_ACTIVE_THREADS, Integer.toString(userMetric.getMinActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MAX_ACTIVE_THREADS, Integer.toString(userMetric.getMaxActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MEAN_ACTIVE_THREADS, Integer.toString(userMetric.getMeanActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_STARTED_THREADS, Integer.toString(userMetric.getStartedThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_FINISHED_THREADS, Integer.toString(userMetric.getFinishedThreads()));
        this.graphiteMetricsManager.writeAndSendMetrics();
    }

    private void addMetrics(long timestampInSeconds, String contextName, SamplerMetric metric) {
        if (metric.getTotal() > 0) {
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_COUNT, Integer.toString(metric.getSuccesses()));
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_COUNT, Integer.toString(metric.getFailures()));
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_COUNT, Integer.toString(metric.getTotal()));
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_HITS_COUNT, Integer.toString(metric.getHits()));
            if (metric.getSuccesses() > 0) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_MIN_RESPONSE_TIME, Double.toString(metric.getOkMinTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_MAX_RESPONSE_TIME, Double.toString(metric.getOkMaxTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_AVG_RESPONSE_TIME, Double.toString(metric.getOkMean()));
                for (Map.Entry<String, Float> entry : this.okPercentiles.entrySet()) {
                    this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getOkPercentile(entry.getValue().floatValue())));
                }
            }
            if (metric.getFailures() > 0) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_MIN_RESPONSE_TIME, Double.toString(metric.getKoMinTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_MAX_RESPONSE_TIME, Double.toString(metric.getKoMaxTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_AVG_RESPONSE_TIME, Double.toString(metric.getKoMean()));
                for (Map.Entry<String, Float> entry : this.koPercentiles.entrySet()) {
                    this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getKoPercentile(entry.getValue().floatValue())));
                }
            }
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_MIN_RESPONSE_TIME, Double.toString(metric.getAllMinTime()));
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_MAX_RESPONSE_TIME, Double.toString(metric.getAllMaxTime()));
            this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_AVG_RESPONSE_TIME, Double.toString(metric.getAllMean()));
            for (Map.Entry<String, Float> entry : this.allPercentiles.entrySet()) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getAllPercentile(entry.getValue().floatValue())));
            }
        }
    }

    public String getSamplersList() {
        return this.samplersList;
    }

    public void setSamplersList(String samplersList) {
        this.samplersList = samplersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        Object object = LOCK;
        synchronized (object) {
            UserMetric userMetrics = this.getUserMetrics();
            for (SampleResult sampleResult : sampleResults) {
                userMetrics.add(sampleResult);
                if (!this.summaryOnly) {
                    boolean samplersToFilterMatch;
                    if (this.useRegexpForSamplersList) {
                        Matcher matcher = this.pattern.matcher(sampleResult.getSampleLabel());
                        samplersToFilterMatch = matcher.matches();
                    } else {
                        samplersToFilterMatch = this.samplersToFilter.contains(sampleResult.getSampleLabel());
                    }
                    if (samplersToFilterMatch) {
                        SamplerMetric samplerMetric = this.getSamplerMetric(sampleResult.getSampleLabel());
                        samplerMetric.add(sampleResult);
                    }
                }
                SamplerMetric cumulatedMetrics = this.getSamplerMetric(CUMULATED_METRICS);
                cumulatedMetrics.add(sampleResult);
            }
        }
    }

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        String graphiteMetricsSenderClass = context.getParameter(GRAPHITE_METRICS_SENDER);
        this.graphiteHost = context.getParameter(GRAPHITE_HOST);
        this.graphitePort = context.getIntParameter(GRAPHITE_PORT, 2003);
        this.summaryOnly = context.getBooleanParameter(SUMMARY_ONLY, true);
        this.samplersList = context.getParameter(SAMPLERS_LIST, "");
        this.useRegexpForSamplersList = context.getBooleanParameter(USE_REGEXP_FOR_SAMPLERS_LIST, false);
        this.rootMetricsPrefix = context.getParameter(ROOT_METRICS_PREFIX, DEFAULT_METRICS_PREFIX);
        String[] percentilesStringArray = context.getParameter(PERCENTILES, DEFAULT_METRICS_PREFIX).split(SEPARATOR);
        this.okPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.koPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.allPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        for (String percentilesString : percentilesStringArray) {
            if (StringUtils.isEmpty((CharSequence)percentilesString.trim())) continue;
            try {
                Float percentileValue = Float.valueOf(percentilesString.trim());
                String sanitizedFormattedPercentile = AbstractGraphiteMetricsSender.sanitizeString(decimalFormat.format(percentileValue));
                this.okPercentiles.put(METRIC_OK_PERCENTILE_PREFIX + sanitizedFormattedPercentile, percentileValue);
                this.koPercentiles.put(METRIC_KO_PERCENTILE_PREFIX + sanitizedFormattedPercentile, percentileValue);
                this.allPercentiles.put(METRIC_ALL_PERCENTILE_PREFIX + sanitizedFormattedPercentile, percentileValue);
            }
            catch (Exception e) {
                log.error("Error parsing percentile: '{}'", (Object)percentilesString, (Object)e);
            }
        }
        Class<?> clazz = Class.forName(graphiteMetricsSenderClass);
        this.graphiteMetricsManager = (GraphiteMetricsSender)clazz.newInstance();
        this.graphiteMetricsManager.setup(this.graphiteHost, this.graphitePort, this.rootMetricsPrefix);
        if (this.useRegexpForSamplersList) {
            this.pattern = Pattern.compile(this.samplersList);
        } else {
            String[] samplers = this.samplersList.split(SEPARATOR);
            this.samplersToFilter = new HashSet<String>();
            Collections.addAll(this.samplersToFilter, samplers);
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.timerHandle = this.scheduler.scheduleAtFixedRate(this, SEND_INTERVAL, SEND_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        boolean cancelState = this.timerHandle.cancel(false);
        log.debug("Canceled state: {}", (Object)cancelState);
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Error waiting for end of scheduler");
            Thread.currentThread().interrupt();
        }
        this.sendMetrics();
        if (this.samplersToFilter != null) {
            this.samplersToFilter.clear();
        }
        this.graphiteMetricsManager.destroy();
        super.teardownTest(context);
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument(GRAPHITE_METRICS_SENDER, TextGraphiteMetricsSender.class.getName());
        arguments.addArgument(GRAPHITE_HOST, "");
        arguments.addArgument(GRAPHITE_PORT, Integer.toString(2003));
        arguments.addArgument(ROOT_METRICS_PREFIX, DEFAULT_METRICS_PREFIX);
        arguments.addArgument(SUMMARY_ONLY, "true");
        arguments.addArgument(SAMPLERS_LIST, "");
        arguments.addArgument(USE_REGEXP_FOR_SAMPLERS_LIST, USE_REGEXP_FOR_SAMPLERS_LIST_DEFAULT);
        arguments.addArgument(PERCENTILES, DEFAULT_PERCENTILES);
        return arguments;
    }
}

