/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.apache.jmeter.config.gui.LoginConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.ldap.config.gui.LdapConfigGui;
import org.apache.jmeter.protocol.ldap.sampler.LDAPSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class LdapTestSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private LoginConfigGui loginPanel;
    private LdapConfigGui ldapDefaultPanel;

    public LdapTestSamplerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.loginPanel.configure(element);
        this.ldapDefaultPanel.configure(element);
    }

    public TestElement createTestElement() {
        LDAPSampler sampler = new LDAPSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        sampler.addTestElement(this.ldapDefaultPanel.createTestElement());
        sampler.addTestElement(this.loginPanel.createTestElement());
        super.configureTestElement(sampler);
    }

    public void clearGui() {
        super.clearGui();
        this.ldapDefaultPanel.clearGui();
        this.loginPanel.clearGui();
    }

    public String getLabelResource() {
        return "ldap_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        VerticalPanel mainPanel = new VerticalPanel();
        this.loginPanel = new LoginConfigGui(false);
        this.ldapDefaultPanel = new LdapConfigGui(false);
        this.loginPanel.setBorder((Border)BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"login_config")));
        this.add(this.makeTitlePanel(), "North");
        mainPanel.add((Component)this.loginPanel);
        mainPanel.add((Component)((Object)this.ldapDefaultPanel));
        this.add((Component)mainPanel, "Center");
    }
}

