/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hierarchy;

import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.state.EContinue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHasChildren<CHILDTYPE> {
    default public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    default public boolean hasNoChildren() {
        return !this.hasChildren();
    }

    @Nonnegative
    public int getChildCount();

    @Nullable
    public ICommonsCollection<? extends CHILDTYPE> getAllChildren();

    default public void forAllChildren(@Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getAllChildren().forEach(consumer);
        }
    }

    @Nonnull
    default public EContinue forAllChildrenBreakable(@Nonnull Function<? super CHILDTYPE, EContinue> function) {
        if (this.hasChildren()) {
            return this.getAllChildren().forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    default public void forAllChildren(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getAllChildren().findAll(predicate, consumer);
        }
    }

    default public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Function<? super CHILDTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        if (this.hasChildren()) {
            this.getAllChildren().findAllMapped(predicate, function, consumer);
        }
    }
}

