/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EInterrupt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ManagedExecutorService {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ManagedExecutorService.class);
    private final ExecutorService m_aES;

    public ManagedExecutorService(@Nonnull ExecutorService executorService) {
        this.m_aES = ValueEnforcer.notNull(executorService, "ExecutorService");
    }

    @Nonnull
    public EInterrupt waitUntilAllTasksAreFinished() {
        return this.waitUntilAllTasksAreFinished(1L, TimeUnit.SECONDS);
    }

    @Nonnull
    public EInterrupt waitUntilAllTasksAreFinished(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        try {
            while (!this.m_aES.awaitTermination(l, timeUnit)) {
            }
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Error waiting for Executor service " + this.m_aES + " to end", (Throwable)interruptedException);
            return EInterrupt.INTERRUPTED;
        }
        return EInterrupt.NOT_INTERRUPTED;
    }

    @Nonnull
    public EInterrupt shutdownAndWaitUntilAllTasksAreFinished() {
        return this.shutdownAndWaitUntilAllTasksAreFinished(1L, TimeUnit.SECONDS);
    }

    @Nonnull
    public EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        if (this.m_aES.isShutdown()) {
            return EInterrupt.NOT_INTERRUPTED;
        }
        this.m_aES.shutdown();
        return this.waitUntilAllTasksAreFinished(l, timeUnit);
    }

    @Nonnull
    public static EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService) {
        return new ManagedExecutorService(executorService).shutdownAndWaitUntilAllTasksAreFinished();
    }

    @Nonnull
    public static EInterrupt shutdownAndWaitUntilAllTasksAreFinished(@Nonnull ExecutorService executorService, @Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        return new ManagedExecutorService(executorService).shutdownAndWaitUntilAllTasksAreFinished(l, timeUnit);
    }
}

