/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.UseDirectEqualsAndHashCode;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.impl.LRUMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUSet<ELEMENTTYPE>
extends AbstractSet<ELEMENTTYPE>
implements ICommonsOrderedSet<ELEMENTTYPE> {
    private final LRUCacheMap m_aMap;

    public LRUSet(@Nonnegative int n) {
        this.m_aMap = new LRUCacheMap(n);
    }

    public LRUSet(@Nonnegative LRUSet<ELEMENTTYPE> lRUSet) {
        this.m_aMap = new LRUCacheMap(lRUSet.m_aMap);
    }

    @Override
    @Nonnull
    public LRUSet<ELEMENTTYPE> getClone() {
        return new LRUSet<ELEMENTTYPE>(this);
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_aMap.getMaxSize();
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.contains(ELEMENTTYPE)) {
            return false;
        }
        this.m_aMap.put(ELEMENTTYPE, Boolean.TRUE);
        return true;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aMap.keySet().iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LRUSet lRUSet = (LRUSet)object;
        return this.m_aMap.equals(lRUSet.m_aMap);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aMap)).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }

    @UseDirectEqualsAndHashCode
    private final class LRUCacheMap
    extends LRUMap<ELEMENTTYPE, Boolean> {
        LRUCacheMap(int n) {
            super(n);
        }

        LRUCacheMap(LRUCacheMap lRUCacheMap) {
            super(lRUCacheMap);
        }

        @Override
        protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<ELEMENTTYPE, Boolean> entry) {
            LRUSet.this.onRemoveEldestEntry(n, entry.getKey());
        }
    }
}

