/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.io.Serializable;
import org.apache.jmeter.timers.RandomTimer;
import org.apache.jmeter.util.JMeterUtils;

public class PoissonRandomTimer
extends RandomTimer
implements Serializable {
    private static final long serialVersionUID = 3514708226113231004L;
    private static final double[] LOG_FACTORIAL = new double[]{0.0, 0.0, 0.693147180559945, 1.791759469228055, 3.178053830347946, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.801827480081469, 15.104412573075516, 17.502307845873887, 19.987214495661885, 22.55216385312342, 25.191221182738683, 27.899271383840894, 30.671860106080675, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485, 45.38013889847691, 48.47118135183523, 51.60667556776438, 54.78472939811232, 58.00360522298052, 61.261701761002, 64.55753862700632, 67.88974313718153, 71.257038967168, 74.65823634883016, 78.0922235533153, 81.55795945611503, 85.05446701758152, 88.58082754219768, 92.13617560368708, 95.7196945421432, 99.33061245478743, 102.96819861451381, 106.63176026064345, 110.32063971475739, 114.03421178146169, 117.77188139974506, 121.53308151543864, 125.31727114935688, 129.12393363912724, 132.9525750356163, 136.80272263732635, 140.67392364823425, 144.5657439463449, 148.47776695177302, 152.40959258449735, 156.3608363030788, 160.33112821663093, 164.32011226319517, 168.32744544842765, 172.35279713916282, 176.39584840699737, 180.45629141754378, 184.5338288614495, 188.6281734236716, 192.7390472878449, 196.86618167288998, 201.00931639928157, 205.1681994826412, 209.34258675253682, 213.53224149456327, 217.73693411395425, 221.95644181913036, 226.19054832372757, 230.43904356577693, 234.70172344281826, 238.97838956183435, 243.26884900298273, 247.5729140961869, 251.8904022097232, 256.2211355500095, 260.5649409718632, 264.9216497985528, 269.2910976510198, 273.6731242856937, 278.0675734403661, 282.4742926876304, 286.893133295427, 291.3239500942703, 295.7666013507606, 300.2209486470141, 304.6868567656687, 309.1641935801469, 313.652829949879, 318.1526396202093, 322.6634991267262, 327.1852877037752, 331.7178871969285, 336.26118197919845, 340.81505887079896, 345.37940706226686, 349.95411804077025, 354.5390855194408, 359.13420536957534, 363.73937555556347, 368.3544960724047, 372.979468885689, 377.61419787391867, 382.25858877306, 386.91254912321756, 391.5759882173296, 396.2488170517915, 400.93094827891576, 405.6222961611449, 410.3227765269373, 415.0323067282496, 419.7508055995448, 424.4781934182571, 429.21439186665157, 433.95932399501487, 438.71291418612117, 443.47508812091894, 448.2457727453846, 453.0248962384961, 457.8123879812781, 462.6081785268749, 467.4121995716081, 472.2243839269805, 477.0446654925856, 481.8729792298879, 486.70926113683936, 491.553448223298, 496.4054784872176, 501.26529089157924, 506.13282534203483, 511.00802266523607, 515.8908245878225, 520.7811737160442, 525.679013515995, 530.5842882944336, 535.4969431801695, 540.4169241059977, 545.344177791155, 550.2786517242856, 555.220294146895, 560.1690540372731, 565.1248810948744, 570.0877257251342, 575.0575390247102, 580.0342727671308, 585.0178793888392, 590.0083119756179, 595.005524249382, 600.0094705553274, 605.0201058494238, 610.0373856862387, 615.0612662070849, 620.0917041284774, 625.1286567308911, 630.1720818478102, 635.2219378550598, 640.2781836604081, 645.340778693435, 650.4096828956552, 655.4848567108891, 660.5662610758735, 665.653857411106, 670.7476076119127, 675.8474740397369, 680.9534195136375, 686.065407301994, 691.1834011144108, 696.307365093814, 701.4372638087372, 706.5730622457875, 711.71472580229, 716.8622202791034, 722.0155118736013, 727.1745671728158, 732.3393531467393, 737.5098371417774, 742.6859868743512, 747.8677704246434, 753.0551562304842, 758.2481130813743, 763.4466101126402, 768.650616799717, 773.8601029525585, 779.0750387101674, 784.2953945352457, 789.521141208959, 794.7522498258135, 799.9886917886435, 805.2304388037031, 810.4774628758636, 815.7297363039102, 820.9872316759379, 826.2499218648428, 831.5177800239063, 836.7907795824699, 842.0688942417005, 847.3520979704384, 852.6403650011331, 857.9336698258575, 863.2319871924054, 868.5352921004646, 873.8435597978657, 879.1567657769076, 884.4748857707518, 889.7978957498902, 895.1257719186799, 900.4584907119453, 905.7960287916463, 911.1383630436112, 916.4854705743288, 921.8373287078049, 927.1939149824767, 932.5552071481862, 937.9211831632081, 943.2918211913357, 948.6670995990198, 954.0469969525604, 959.4314920153495, 964.8205637451659, 970.2141912915183, 975.6123539930362, 981.0150313749084, 986.4222031463686, 991.8338491982234, 997.2499496004278, 1002.6704845997003, 1008.0954346171817, 1013.5247802461362, 1018.9585022496902, 1024.3965815586134, 1029.8389992691355, 1035.2857366408016, 1040.7367750943674, 1046.192096209725, 1051.6516817238692, 1057.115513528895, 1062.58357367003, 1068.0558443437014, 1073.5323078956328, 1079.012946818975, 1084.4977437524656, 1089.9866814786224, 1095.4797429219627, 1100.976911147256, 1106.4781693578009, 1111.983500893733, 1117.492889230361, 1123.0063179765261, 1128.5237708729908, 1134.045231790853, 1139.5706847299848, 1145.100113817496, 1150.6335033062237, 1156.1708375732424};

    @Override
    public long delay() {
        return Math.abs((long)PoissonRandomTimer.randomPoisson((int)Math.round(this.getRange())) + super.delay());
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"poisson_timer_memo");
    }

    private static int randomPoisson(int lambda) {
        if (lambda <= 30) {
            return PoissonRandomTimer.poissonRandomNumberLowEq30(lambda);
        }
        return PoissonRandomTimer.poissonRandomNumberSup30(lambda);
    }

    private static int poissonRandomNumberLowEq30(int lambda) {
        double u;
        double L = Math.exp(-lambda);
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= (u = Math.random())) > L);
        return k - 1;
    }

    private static int poissonRandomNumberSup30(int lambda) {
        double rhs;
        double v;
        double y;
        double lhs;
        double u;
        double x;
        int n;
        double c = 0.767 - 3.36 / (double)lambda;
        double beta = Math.PI / Math.sqrt(3.0 * (double)lambda);
        double alpha = beta * (double)lambda;
        double k = Math.log(c) - (double)lambda - Math.log(beta);
        while ((n = (int)Math.floor((x = (alpha - Math.log((1.0 - (u = Math.random())) / u)) / beta) + 0.5)) < 0 || !((lhs = (y = alpha - beta * x) + Math.log((v = Math.random()) / Math.pow(1.0 + Math.exp(y), 2.0))) <= (rhs = k + (double)n * Math.log(lambda) - PoissonRandomTimer.logFactorial(n)))) {
        }
        return n;
    }

    private static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 254) {
            double x = (double)n + 1.0;
            return (x - 0.5) * Math.log(x) - x + 0.5 * Math.log(Math.PI * 2) + 1.0 / (12.0 * x);
        }
        return LOG_FACTORIAL[n];
    }
}

