/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;

public class TimerService {
    private TimerService() {
    }

    public static TimerService getInstance() {
        return TimerServiceHolder.INSTANCE;
    }

    public long adjustDelay(long initialDelay) {
        JMeterThread thread = JMeterContextService.getContext().getThread();
        long endTime = thread != null ? thread.getEndTime() : 0L;
        return this.adjustDelay(initialDelay, endTime);
    }

    public long adjustDelay(long initialDelay, long endTime) {
        long now;
        if (endTime > 0L && (now = System.currentTimeMillis()) + initialDelay > endTime) {
            return endTime - now;
        }
        return initialDelay;
    }

    private static class TimerServiceHolder {
        public static final TimerService INSTANCE = new TimerService();

        private TimerServiceHolder() {
        }
    }
}

