/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jorphan.collections.ListedHashTree;

public abstract class AbstractThreadGroup
extends AbstractTestElement
implements Serializable,
Controller,
JMeterThreadMonitor,
TestCompilerHelper {
    private static final long serialVersionUID = 240L;
    private final transient ConcurrentMap<TestElement, Object> children = new ConcurrentHashMap<TestElement, Object>();
    private static final Object DUMMY = new Object();
    public static final String ON_SAMPLE_ERROR = "ThreadGroup.on_sample_error";
    public static final String ON_SAMPLE_ERROR_CONTINUE = "continue";
    public static final String ON_SAMPLE_ERROR_START_NEXT_LOOP = "startnextloop";
    public static final String ON_SAMPLE_ERROR_STOPTHREAD = "stopthread";
    public static final String ON_SAMPLE_ERROR_STOPTEST = "stoptest";
    public static final String ON_SAMPLE_ERROR_STOPTEST_NOW = "stoptestnow";
    public static final String NUM_THREADS = "ThreadGroup.num_threads";
    public static final String MAIN_CONTROLLER = "ThreadGroup.main_controller";
    private final AtomicInteger numberOfThreads = new AtomicInteger(0);

    @Override
    public boolean isDone() {
        return this.getSamplerController().isDone();
    }

    @Override
    public Sampler next() {
        return this.getSamplerController().next();
    }

    public Controller getSamplerController() {
        return (Controller)this.getProperty(MAIN_CONTROLLER).getObjectValue();
    }

    public void setSamplerController(LoopController c) {
        c.setContinueForever(false);
        this.setProperty(new TestElementProperty(MAIN_CONTROLLER, c));
    }

    @Override
    public void addTestElement(TestElement child) {
        this.getSamplerController().addTestElement(child);
    }

    @Override
    public final boolean addTestElementOnce(TestElement child) {
        if (this.children.putIfAbsent(child, DUMMY) == null) {
            this.addTestElement(child);
            return true;
        }
        return false;
    }

    @Override
    public void addIterationListener(LoopIterationListener lis) {
        this.getSamplerController().addIterationListener(lis);
    }

    @Override
    public void removeIterationListener(LoopIterationListener iterationListener) {
        this.getSamplerController().removeIterationListener(iterationListener);
    }

    @Override
    public void initialize() {
        Controller c = this.getSamplerController();
        JMeterProperty property = c.getProperty("TestElement.name");
        property.setObjectValue(this.getName());
        property.setRunningVersion(property.isRunningVersion());
        c.initialize();
    }

    public void startNextLoop() {
        ((LoopController)this.getSamplerController()).startNextLoop();
    }

    @Override
    public void triggerEndOfLoop() {
    }

    public void setNumThreads(int numThreads) {
        this.setProperty(new IntegerProperty(NUM_THREADS, numThreads));
    }

    void incrNumberOfThreads() {
        this.numberOfThreads.incrementAndGet();
    }

    void decrNumberOfThreads() {
        this.numberOfThreads.decrementAndGet();
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads.get();
    }

    public int getNumThreads() {
        return this.getPropertyAsInt(NUM_THREADS);
    }

    public boolean getOnErrorStartNextLoop() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_START_NEXT_LOOP);
    }

    public boolean getOnErrorStopThread() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTHREAD);
    }

    public boolean getOnErrorStopTest() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST);
    }

    public boolean getOnErrorStopTestNow() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST_NOW);
    }

    public abstract boolean stopThread(String var1, boolean var2);

    public abstract int numberOfActiveThreads();

    public abstract void start(int var1, ListenerNotifier var2, ListedHashTree var3, StandardJMeterEngine var4);

    public abstract JMeterThread addNewThread(int var1, StandardJMeterEngine var2);

    public abstract boolean verifyThreadsStopped();

    public abstract void waitThreadsStopped();

    public abstract void tellThreadsToStop();

    public abstract void stop();
}

