/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.jorphan.collections.HashTree;

public class HashTreeConverter
extends AbstractCollectionConverter {
    public static String getVersion() {
        return "$Revision: 1647347 $";
    }

    public boolean canConvert(Class arg0) {
        return HashTree.class.isAssignableFrom(arg0);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter writer, MarshallingContext context) {
        HashTree tree = (HashTree)arg0;
        for (Object item : tree.list()) {
            this.writeItem(item, context, writer);
            this.writeItem(tree.getTree(item), context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        boolean isKey = true;
        Object current = null;
        HashTree tree = (HashTree)this.createCollection(context.getRequiredType());
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object item = this.readItem(reader, context, tree);
            if (isKey) {
                tree.add(item);
                current = item;
                isKey = false;
            } else {
                tree.set(current, (HashTree)item);
                isKey = true;
            }
            reader.moveUp();
        }
        return tree;
    }

    public HashTreeConverter(Mapper arg0) {
        super(arg0);
    }
}

