/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSaver
extends AbstractTestElement
implements NoThreadClone,
Serializable,
SampleListener,
TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(ResultSaver.class);
    private static final long serialVersionUID = 242L;
    private static final Object LOCK = new Object();
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmm_";
    public static final String FILENAME = "FileSaver.filename";
    public static final String VARIABLE_NAME = "FileSaver.variablename";
    public static final String ERRORS_ONLY = "FileSaver.errorsonly";
    public static final String SUCCESS_ONLY = "FileSaver.successonly";
    public static final String SKIP_AUTO_NUMBER = "FileSaver.skipautonumber";
    public static final String SKIP_SUFFIX = "FileSaver.skipsuffix";
    public static final String ADD_TIMESTAMP = "FileSaver.addTimstamp";
    public static final String NUMBER_PAD_LENGTH = "FileSaver.numberPadLen";
    private long sequenceNumber = 0L;
    private String timeStamp;
    private int numberPadLength;

    public ResultSaver() {
    }

    public ResultSaver(String name) {
        this();
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextNumber() {
        Object object = LOCK;
        synchronized (object) {
            return ++this.sequenceNumber;
        }
    }

    @Override
    public void testStarted() {
        this.testStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            this.sequenceNumber = 0L;
            if (this.getAddTimeStamp()) {
                SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
                this.timeStamp = format.format(new Date());
            } else {
                this.timeStamp = "";
            }
            this.numberPadLength = this.getNumberPadLen();
        }
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String host) {
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.processSample(e.getResult(), new Counter());
    }

    private void processSample(SampleResult s, Counter c) {
        SampleResult[] sampleResults;
        this.saveSample(s, c.num++);
        for (SampleResult sampleResult : sampleResults = s.getSubResults()) {
            this.processSample(sampleResult, c);
        }
    }

    private void saveSample(SampleResult s, int num) {
        if (s.isSuccessful() ? this.getErrorsOnly() : this.getSuccessOnly()) {
            return;
        }
        String fileName = this.makeFileName(s.getContentType(), this.getSkipAutoNumber(), this.getSkipSuffix());
        if (log.isDebugEnabled()) {
            log.debug("Saving {} in {}", (Object)s.getSampleLabel(), (Object)fileName);
        }
        s.setResultFileName(fileName);
        String variable = this.getVariableName();
        if (variable.length() > 0) {
            if (num > 0) {
                StringBuilder sb = new StringBuilder(variable);
                sb.append(num);
                variable = sb.toString();
            }
            JMeterContextService.getContext().getVariables().put(variable, fileName);
        }
        File out = new File(fileName);
        try (FileOutputStream fos = new FileOutputStream(out);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            JOrphanUtils.write((byte[])s.getResponseData(), (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            log.error("Error creating sample file for {}", (Object)s.getSampleLabel(), (Object)e);
        }
        catch (IOException e) {
            log.error("Error saving sample {}", (Object)s.getSampleLabel(), (Object)e);
        }
    }

    String makeFileName(String contentType, boolean skipAutoNumber, boolean skipSuffix) {
        StringBuilder sb = new StringBuilder(FileServer.resolveBaseRelativeName(this.getFilename()));
        sb.append(this.timeStamp);
        if (!skipAutoNumber) {
            String number = Long.toString(this.nextNumber());
            for (int i = number.length(); i < this.numberPadLength; ++i) {
                sb.append('0');
            }
            sb.append(number);
        }
        if (!skipSuffix) {
            sb.append('.');
            if (contentType != null) {
                int i = contentType.indexOf(47);
                if (i != -1) {
                    int j = contentType.indexOf(59);
                    if (j != -1) {
                        sb.append(contentType.substring(i + 1, j));
                    } else {
                        sb.append(contentType.substring(i + 1));
                    }
                } else {
                    sb.append("unknown");
                }
            } else {
                sb.append("unknown");
            }
        }
        return sb.toString();
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    private String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    private String getVariableName() {
        return this.getPropertyAsString(VARIABLE_NAME, "");
    }

    private boolean getErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY);
    }

    private boolean getSkipAutoNumber() {
        return this.getPropertyAsBoolean(SKIP_AUTO_NUMBER);
    }

    private boolean getSkipSuffix() {
        return this.getPropertyAsBoolean(SKIP_SUFFIX);
    }

    private boolean getSuccessOnly() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY);
    }

    private boolean getAddTimeStamp() {
        return this.getPropertyAsBoolean(ADD_TIMESTAMP);
    }

    private int getNumberPadLen() {
        return this.getPropertyAsInt(NUMBER_PAD_LENGTH, 0);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private static class Counter {
        int num;

        private Counter() {
        }
    }
}

