/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.apache.jmeter.gui.UndoHistory;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.IconToolbarBean;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterToolBar
extends JToolBar
implements LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JMeterToolBar.class);
    private static final String TOOLBAR_ENTRY_SEP = ",";
    private static final String TOOLBAR_PROP_NAME = "toolbar";
    protected static final String DEFAULT_TOOLBAR_PROPERTY_FILE = "org/apache/jmeter/images/toolbar/icons-toolbar.properties";
    protected static final String USER_DEFINED_TOOLBAR_PROPERTY_FILE = "jmeter.toolbar.icons";
    public static final String TOOLBAR_ICON_SIZE = "jmeter.toolbar.icons.size";
    public static final String DEFAULT_TOOLBAR_ICON_SIZE = "22x22";
    protected static final String TOOLBAR_LIST = "jmeter.toolbar";

    public static JMeterToolBar createToolbar(boolean visible) {
        JMeterToolBar toolBar = new JMeterToolBar();
        toolBar.setFloatable(false);
        toolBar.setVisible(visible);
        JMeterToolBar.setupToolbarContent(toolBar);
        JMeterUtils.addLocaleChangeListener(toolBar);
        return toolBar;
    }

    private static void setupToolbarContent(JMeterToolBar toolBar) {
        List<IconToolbarBean> icons = JMeterToolBar.getIconMappings();
        if (icons != null) {
            for (IconToolbarBean iconToolbarBean : icons) {
                if (iconToolbarBean == null) {
                    toolBar.addSeparator();
                    continue;
                }
                try {
                    if ("undo".equalsIgnoreCase(iconToolbarBean.getActionName()) || "redo".equalsIgnoreCase(iconToolbarBean.getActionName())) {
                        if (!UndoHistory.isEnabled()) continue;
                        toolBar.add(JMeterToolBar.makeButtonItemRes(iconToolbarBean));
                        continue;
                    }
                    toolBar.add(JMeterToolBar.makeButtonItemRes(iconToolbarBean));
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Exception while adding button item to toolbar. {}", (Object)e.getMessage());
                }
            }
            toolBar.initButtonsState();
        }
    }

    private static JButton makeButtonItemRes(IconToolbarBean iconBean) throws Exception {
        URL imageURL = JMeterUtils.class.getClassLoader().getResource(iconBean.getIconPath());
        if (imageURL == null) {
            throw new Exception("No icon for: " + iconBean.getActionName());
        }
        JButton button = new JButton(new ImageIcon(imageURL));
        button.setToolTipText(JMeterUtils.getResString(iconBean.getI18nKey()));
        URL imageURLPressed = JMeterUtils.class.getClassLoader().getResource(iconBean.getIconPathPressed());
        button.setPressedIcon(new ImageIcon(imageURLPressed));
        button.addActionListener(ActionRouter.getInstance());
        button.setActionCommand(iconBean.getActionNameResolve());
        return button;
    }

    private static List<IconToolbarBean> getIconMappings() {
        Properties defaultProps = JMeterUtils.loadProperties(DEFAULT_TOOLBAR_PROPERTY_FILE);
        if (defaultProps == null) {
            JOptionPane.showMessageDialog(null, JMeterUtils.getResString("toolbar_icon_set_not_found"), JMeterUtils.getResString("toolbar_icon_set_not_found"), 2);
            return null;
        }
        String userProp = JMeterUtils.getProperty(USER_DEFINED_TOOLBAR_PROPERTY_FILE);
        Properties p = userProp != null ? JMeterUtils.loadProperties(userProp, defaultProps) : defaultProps;
        String order = JMeterUtils.getPropDefault(TOOLBAR_LIST, p.getProperty(TOOLBAR_PROP_NAME));
        if (order == null) {
            log.warn("Could not find toolbar definition list");
            JOptionPane.showMessageDialog(null, JMeterUtils.getResString("toolbar_icon_set_not_found"), JMeterUtils.getResString("toolbar_icon_set_not_found"), 2);
            return null;
        }
        String[] oList = order.split(TOOLBAR_ENTRY_SEP);
        String iconSize = JMeterUtils.getPropDefault(TOOLBAR_ICON_SIZE, DEFAULT_TOOLBAR_ICON_SIZE);
        ArrayList<IconToolbarBean> listIcons = new ArrayList<IconToolbarBean>();
        for (String key : oList) {
            log.debug("Toolbar icon key: {}", (Object)key);
            String trimmed = key.trim();
            if (trimmed.equals("|")) {
                listIcons.add(null);
                continue;
            }
            String property = p.getProperty(trimmed);
            if (property == null) {
                log.warn("No definition for toolbar entry: {}", (Object)key);
                continue;
            }
            try {
                IconToolbarBean itb = new IconToolbarBean(property, iconSize);
                listIcons.add(itb);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return listIcons;
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        Map<String, Boolean> currentButtonStates = this.getCurrentButtonsStates();
        this.removeAll();
        JMeterToolBar.setupToolbarContent(this);
        this.updateButtons(currentButtonStates);
    }

    private Map<String, Boolean> getCurrentButtonsStates() {
        Component[] components = this.getComponents();
        HashMap<String, Boolean> buttonStates = new HashMap<String, Boolean>(components.length);
        for (Component component : components) {
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            buttonStates.put(button.getActionCommand(), button.isEnabled());
        }
        return buttonStates;
    }

    public void initButtonsState() {
        HashMap<String, Boolean> buttonStates = new HashMap<String, Boolean>();
        buttonStates.put("start", Boolean.TRUE);
        buttonStates.put("start_no_timers", Boolean.TRUE);
        buttonStates.put("stop", Boolean.FALSE);
        buttonStates.put("shutdown", Boolean.FALSE);
        buttonStates.put("undo", Boolean.FALSE);
        buttonStates.put("redo", Boolean.FALSE);
        buttonStates.put("remote_start_all", Boolean.TRUE);
        buttonStates.put("remote_stop_all", Boolean.FALSE);
        buttonStates.put("remote_shut_all", Boolean.FALSE);
        this.updateButtons(buttonStates);
    }

    public void setLocalTestStarted(boolean started) {
        HashMap<String, Boolean> buttonStates = new HashMap<String, Boolean>(3);
        buttonStates.put("start", !started);
        buttonStates.put("start_no_timers", !started);
        buttonStates.put("stop", started);
        buttonStates.put("shutdown", started);
        this.updateButtons(buttonStates);
    }

    public void setRemoteTestStarted(boolean started) {
        HashMap<String, Boolean> buttonStates = new HashMap<String, Boolean>(3);
        buttonStates.put("remote_start_all", !started);
        buttonStates.put("remote_stop_all", started);
        buttonStates.put("remote_shut_all", started);
        this.updateButtons(buttonStates);
    }

    public void updateUndoRedoIcons(boolean canUndo, boolean canRedo) {
        HashMap<String, Boolean> buttonStates = new HashMap<String, Boolean>(2);
        buttonStates.put("undo", canUndo);
        buttonStates.put("redo", canRedo);
        this.updateButtons(buttonStates);
    }

    private void updateButtons(Map<String, Boolean> buttonStates) {
        for (Component component : this.getComponents()) {
            JButton button;
            Boolean enabled;
            if (!(component instanceof JButton) || (enabled = buttonStates.get((button = (JButton)component).getActionCommand())) == null) continue;
            button.setEnabled(enabled);
        }
    }
}

