/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.PreCompiler;
import org.apache.jmeter.engine.TurnElementsOn;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.PostThreadGroup;
import org.apache.jmeter.threads.SetupThreadGroup;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.util.JMeterStopTestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJMeterEngine
implements JMeterEngine,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(StandardJMeterEngine.class);
    private static final boolean EXIT_AFTER_TEST = JMeterUtils.getPropDefault("server.exitaftertest", false);
    private static volatile StandardJMeterEngine engine;
    private static final List<TestStateListener> testList;
    private static final boolean REMOTE_SYSTEM_EXIT;
    private static final boolean SYSTEM_EXIT_ON_STOP_FAIL;
    private static final boolean SYSTEM_EXIT_FORCED;
    private volatile boolean running = false;
    private volatile boolean shutdown = false;
    private volatile boolean active = false;
    private volatile boolean serialized = false;
    private volatile boolean tearDownOnShutdown = false;
    private HashTree test;
    private final String host;
    private final List<AbstractThreadGroup> groups = new CopyOnWriteArrayList<AbstractThreadGroup>();

    public StandardJMeterEngine() {
        this(null);
    }

    public StandardJMeterEngine(String host) {
        this.host = host;
        StandardJMeterEngine.initSingletonEngine(this);
    }

    private static void initSingletonEngine(StandardJMeterEngine standardJMeterEngine) {
        engine = standardJMeterEngine;
    }

    private static void resetSingletonEngine() {
        engine = null;
    }

    public static void stopEngineNow() {
        if (engine != null) {
            engine.stopTest(true);
        }
    }

    public static void stopEngine() {
        if (engine != null) {
            engine.stopTest(false);
        }
    }

    public static synchronized void register(TestStateListener tl) {
        testList.add(tl);
    }

    public static boolean stopThread(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, false);
    }

    public static boolean stopThreadNow(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, true);
    }

    private static boolean stopThread(String threadName, boolean now) {
        if (engine == null) {
            return false;
        }
        boolean wasStopped = false;
        for (AbstractThreadGroup threadGroup : StandardJMeterEngine.engine.groups) {
            wasStopped = wasStopped || threadGroup.stopThread(threadName, now);
        }
        return wasStopped;
    }

    @Override
    public void configure(HashTree testTree) {
        SearchByClass testPlan = new SearchByClass(TestPlan.class);
        testTree.traverse((HashTreeTraverser)testPlan);
        Object[] plan = testPlan.getSearchResults().toArray();
        if (plan.length == 0) {
            throw new RuntimeException("Could not find the TestPlan class!");
        }
        TestPlan tp = (TestPlan)plan[0];
        this.serialized = tp.isSerialized();
        this.tearDownOnShutdown = tp.isTearDownOnShutdown();
        this.active = true;
        this.test = testTree;
    }

    @Override
    public void runTest() throws JMeterEngineException {
        if (this.host != null) {
            long now = System.currentTimeMillis();
            System.out.println("Starting the test on host " + this.host + " @ " + new Date(now) + " (" + now + ")");
        }
        try {
            Thread runningThread = new Thread((Runnable)this, "StandardJMeterEngine");
            runningThread.start();
        }
        catch (Exception err) {
            this.stopTest();
            throw new JMeterEngineException(err);
        }
    }

    private void removeThreadGroups(List<?> elements) {
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof AbstractThreadGroup) {
                iter.remove();
                continue;
            }
            if (item instanceof TestElement) continue;
            iter.remove();
        }
    }

    private void notifyTestListenersOfStart(SearchByClass<TestStateListener> testListeners) {
        for (TestStateListener tl : testListeners.getSearchResults()) {
            if (tl instanceof TestBean) {
                TestBeanHelper.prepare((TestElement)((Object)tl));
            }
            if (this.host == null) {
                tl.testStarted();
                continue;
            }
            tl.testStarted(this.host);
        }
    }

    private void notifyTestListenersOfEnd(SearchByClass<TestStateListener> testListeners) {
        log.info("Notifying test listeners of end of test");
        for (TestStateListener tl : testListeners.getSearchResults()) {
            try {
                if (this.host == null) {
                    tl.testEnded();
                    continue;
                }
                tl.testEnded(this.host);
            }
            catch (Exception e) {
                log.warn("Error encountered during shutdown of " + tl.toString(), (Throwable)e);
            }
        }
        if (this.host != null) {
            log.info("Test has ended on host " + this.host);
            long now = System.currentTimeMillis();
            System.out.println("Finished the test on host " + this.host + " @ " + new Date(now) + " (" + now + ")" + (EXIT_AFTER_TEST ? " - exit requested." : ""));
            if (EXIT_AFTER_TEST) {
                this.exit();
            }
        }
        this.active = false;
    }

    @Override
    public void reset() {
        if (this.running) {
            this.stopTest();
        }
    }

    @Override
    public synchronized void stopTest() {
        this.stopTest(true);
    }

    @Override
    public synchronized void stopTest(boolean now) {
        this.shutdown = !now;
        Thread stopThread = new Thread(new StopTest(now));
        stopThread.start();
    }

    @Override
    public void run() {
        String groupName;
        AbstractThreadGroup group;
        log.info("Running the test!");
        this.running = true;
        SampleEvent.initSampleVariables();
        JMeterContextService.startTest();
        try {
            PreCompiler compiler = new PreCompiler();
            this.test.traverse((HashTreeTraverser)compiler);
        }
        catch (RuntimeException e) {
            log.error("Error occurred compiling the tree:", (Throwable)e);
            JMeterUtils.reportErrorToUser("Error occurred compiling the tree: - see log file", e);
            return;
        }
        SearchByClass testListeners = new SearchByClass(TestStateListener.class);
        this.test.traverse((HashTreeTraverser)testListeners);
        testListeners.getSearchResults().addAll(testList);
        testList.clear();
        this.test.traverse((HashTreeTraverser)new TurnElementsOn());
        this.notifyTestListenersOfStart((SearchByClass<TestStateListener>)testListeners);
        LinkedList testLevelElements = new LinkedList(this.test.list(this.test.getArray()[0]));
        this.removeThreadGroups(testLevelElements);
        SearchByClass setupSearcher = new SearchByClass(SetupThreadGroup.class);
        SearchByClass searcher = new SearchByClass(AbstractThreadGroup.class);
        SearchByClass postSearcher = new SearchByClass(PostThreadGroup.class);
        this.test.traverse((HashTreeTraverser)setupSearcher);
        this.test.traverse((HashTreeTraverser)searcher);
        this.test.traverse((HashTreeTraverser)postSearcher);
        TestCompiler.initialize();
        Iterator setupIter = setupSearcher.getSearchResults().iterator();
        Iterator iter = searcher.getSearchResults().iterator();
        Iterator postIter = postSearcher.getSearchResults().iterator();
        ListenerNotifier notifier = new ListenerNotifier();
        int groupCount = 0;
        JMeterContextService.clearTotalThreads();
        if (setupIter.hasNext()) {
            log.info("Starting setUp thread groups");
            while (this.running && setupIter.hasNext()) {
                AbstractThreadGroup group2 = (AbstractThreadGroup)setupIter.next();
                String groupName2 = group2.getName();
                log.info("Starting setUp ThreadGroup: " + ++groupCount + " : " + groupName2);
                this.startThreadGroup(group2, groupCount, setupSearcher, testLevelElements, notifier);
                if (!this.serialized || !setupIter.hasNext()) continue;
                log.info("Waiting for setup thread group: " + groupName2 + " to finish before starting next setup group");
                group2.waitThreadsStopped();
            }
            log.info("Waiting for all setup thread groups to exit");
            this.waitThreadsStopped();
            log.info("All Setup Threads have ended");
            groupCount = 0;
            JMeterContextService.clearTotalThreads();
        }
        this.groups.clear();
        JMeterUtils.helpGC();
        JMeterContextService.getContext().setSamplingStarted(true);
        boolean mainGroups = this.running;
        while (this.running && iter.hasNext()) {
            group = (AbstractThreadGroup)iter.next();
            if (group instanceof SetupThreadGroup || group instanceof PostThreadGroup) continue;
            groupName = group.getName();
            log.info("Starting ThreadGroup: " + ++groupCount + " : " + groupName);
            this.startThreadGroup(group, groupCount, searcher, testLevelElements, notifier);
            if (!this.serialized || !iter.hasNext()) continue;
            log.info("Waiting for thread group: " + groupName + " to finish before starting next group");
            group.waitThreadsStopped();
        }
        if (groupCount == 0) {
            log.info("No enabled thread groups found");
        } else if (this.running) {
            log.info("All thread groups have been started");
        } else {
            log.info("Test stopped - no more thread groups will be started");
        }
        this.waitThreadsStopped();
        this.groups.clear();
        if (postIter.hasNext()) {
            groupCount = 0;
            JMeterContextService.clearTotalThreads();
            log.info("Starting tearDown thread groups");
            if (mainGroups && !this.running) {
                boolean bl = this.running = this.shutdown && this.tearDownOnShutdown;
            }
            while (this.running && postIter.hasNext()) {
                group = (AbstractThreadGroup)postIter.next();
                groupName = group.getName();
                log.info("Starting tearDown ThreadGroup: " + ++groupCount + " : " + groupName);
                this.startThreadGroup(group, groupCount, postSearcher, testLevelElements, notifier);
                if (!this.serialized || !postIter.hasNext()) continue;
                log.info("Waiting for post thread group: " + groupName + " to finish before starting next post group");
                group.waitThreadsStopped();
            }
            this.waitThreadsStopped();
        }
        this.notifyTestListenersOfEnd((SearchByClass<TestStateListener>)testListeners);
        JMeterContextService.endTest();
        if (JMeter.isNonGUI() && SYSTEM_EXIT_FORCED) {
            log.info("Forced JVM shutdown requested at end of test");
            System.exit(0);
        }
    }

    private void startThreadGroup(AbstractThreadGroup group, int groupCount, SearchByClass<?> searcher, List<?> testLevelElements, ListenerNotifier notifier) {
        try {
            int numThreads = group.getNumThreads();
            JMeterContextService.addTotalThreads(numThreads);
            boolean onErrorStopTest = group.getOnErrorStopTest();
            boolean onErrorStopTestNow = group.getOnErrorStopTestNow();
            boolean onErrorStopThread = group.getOnErrorStopThread();
            boolean onErrorStartNextLoop = group.getOnErrorStartNextLoop();
            String groupName = group.getName();
            log.info("Starting " + numThreads + " threads for group " + groupName + ".");
            if (onErrorStopTest) {
                log.info("Test will stop on error");
            } else if (onErrorStopTestNow) {
                log.info("Test will stop abruptly on error");
            } else if (onErrorStopThread) {
                log.info("Thread will stop on error");
            } else if (onErrorStartNextLoop) {
                log.info("Thread will start next loop on error");
            } else {
                log.info("Thread will continue on error");
            }
            ListedHashTree threadGroupTree = (ListedHashTree)searcher.getSubTree((Object)group);
            threadGroupTree.add((Object)group, testLevelElements);
            this.groups.add(group);
            group.start(groupCount, notifier, threadGroupTree, this);
        }
        catch (JMeterStopTestException ex) {
            JMeterUtils.reportErrorToUser("Error occurred starting thread group :" + group.getName() + ", error message:" + ex.getMessage() + ", \r\nsee log file for more details", (Exception)((Object)ex));
            return;
        }
    }

    private void waitThreadsStopped() {
        for (AbstractThreadGroup threadGroup : this.groups) {
            threadGroup.waitThreadsStopped();
        }
    }

    public void askThreadsToStop() {
        if (engine != null) {
            engine.stopTest(false);
        }
    }

    @Override
    public void exit() {
        ClientJMeterEngine.tidyRMI(log);
        if (REMOTE_SYSTEM_EXIT) {
            log.warn("About to run System.exit(0) on " + this.host);
            Thread t = new Thread(){

                @Override
                public void run() {
                    StandardJMeterEngine.this.pause(1000L);
                    log.info("Bye from " + StandardJMeterEngine.this.host);
                    System.out.println("Bye from " + StandardJMeterEngine.this.host);
                    System.exit(0);
                }
            };
            t.start();
        }
    }

    private void pause(long ms) {
        try {
            TimeUnit.MILLISECONDS.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void setProperties(Properties p) {
        log.info("Applying properties " + p);
        JMeterUtils.getJMeterProperties().putAll((Map<?, ?>)p);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    static {
        testList = new ArrayList<TestStateListener>();
        REMOTE_SYSTEM_EXIT = JMeterUtils.getPropDefault("jmeterengine.remote.system.exit", false);
        SYSTEM_EXIT_ON_STOP_FAIL = JMeterUtils.getPropDefault("jmeterengine.stopfail.system.exit", true);
        SYSTEM_EXIT_FORCED = JMeterUtils.getPropDefault("jmeterengine.force.system.exit", false);
    }

    private class StopTest
    implements Runnable {
        private final boolean now;

        private StopTest(boolean b) {
            this.now = b;
        }

        private void stopAllThreadGroups() {
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                threadGroup.stop();
            }
        }

        private void tellThreadGroupsToStop() {
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                threadGroup.tellThreadsToStop();
            }
        }

        private boolean verifyThreadsStopped() {
            boolean stoppedAll = true;
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                stoppedAll = stoppedAll && threadGroup.verifyThreadsStopped();
            }
            return stoppedAll;
        }

        private int countStillActiveThreads() {
            int reminingThreads = 0;
            for (AbstractThreadGroup threadGroup : StandardJMeterEngine.this.groups) {
                reminingThreads += threadGroup.numberOfActiveThreads();
            }
            return reminingThreads;
        }

        @Override
        public void run() {
            StandardJMeterEngine.this.running = false;
            StandardJMeterEngine.resetSingletonEngine();
            if (this.now) {
                this.tellThreadGroupsToStop();
                StandardJMeterEngine.this.pause(10L * (long)this.countStillActiveThreads());
                boolean stopped = this.verifyThreadsStopped();
                if (!stopped) {
                    if (JMeter.isNonGUI()) {
                        log.error(JMeterUtils.getResString("stopping_test_failed"));
                        if (SYSTEM_EXIT_ON_STOP_FAIL) {
                            log.error("Exiting");
                            System.out.println("Fatal error, could not stop test, exiting");
                            System.exit(1);
                        } else {
                            System.out.println("Fatal error, could not stop test");
                        }
                    } else {
                        JMeterUtils.reportErrorToUser(JMeterUtils.getResString("stopping_test_failed"), JMeterUtils.getResString("stopping_test_title"));
                    }
                }
            } else {
                this.stopAllThreadGroups();
            }
        }
    }
}

