/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoUnit;
import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsWithin<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final long period;
    private final ChronoUnit unit;
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsWithin(long period, ChronoUnit unit, TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.period = period;
        this.unit = unit;
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        long actualDuration = this.expected.difference(actual, this.unit);
        if (actualDuration > this.period) {
            mismatchDesc.appendText("the date is " + this.describer.describe(actual) + " and " + actualDuration + " " + this.describeUnit() + " different");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is within " + this.period + " " + this.describeUnit() + " of " + this.describer.describe(this.expected.unwrap()));
    }

    private String describeUnit() {
        return this.unit.toString().toLowerCase();
    }
}

