/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeNode;
import org.apache.jorphan.gui.TreeTableModel;
import org.apache.jorphan.reflect.Functor;

public abstract class AbstractTreeTableModel
extends DefaultTableModel
implements TreeTableModel {
    private static final long serialVersionUID = 240L;
    protected final TreeNode rootNode;
    protected final EventListenerList listener = new EventListenerList();
    protected final transient List<Object> objects = new ArrayList<Object>();
    protected final transient List<String> headers = new ArrayList<String>();
    protected final transient List<Class<?>> classes = new ArrayList();
    protected final transient List<Functor> readFunctors;
    protected final transient List<Functor> writeFunctors;

    public AbstractTreeTableModel(TreeNode root) {
        this.rootNode = root;
        this.readFunctors = new ArrayList<Functor>();
        this.writeFunctors = new ArrayList<Functor>();
    }

    public AbstractTreeTableModel(String[] headers, Functor[] readFunctors, Functor[] writeFunctors, Class<?>[] editorClasses) {
        this.rootNode = null;
        this.headers.addAll(Arrays.asList(headers));
        this.classes.addAll(Arrays.asList(editorClasses));
        this.readFunctors = new ArrayList<Functor>(Arrays.asList(readFunctors));
        this.writeFunctors = new ArrayList<Functor>(Arrays.asList(writeFunctors));
    }

    public Object getRootNode() {
        return this.rootNode;
    }

    @Override
    public Object getValueAt(Object node, int col) {
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object val, Object node, int column) {
    }

    @Override
    public int getColumnCount() {
        return this.headers.size();
    }

    @Override
    public int getRowCount() {
        return this.objects.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return this.classes.get(arg0);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.headers.get(columnIndex);
    }

    public int getChildCount(Object parent) {
        return 0;
    }

    public Object getChild(Object parent, int index) {
        return null;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof TreeNode) {
            return ((TreeNode)node).isLeaf();
        }
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(TableModelListener.class, l);
    }

    public void nodeStructureChanged(TreeNode node) {
    }

    public void fireTreeNodesChanged(TreeNode source, Object[] path, int[] indexes, Object[] children) {
    }

    public void clearData() {
        int size = this.getRowCount();
        this.objects.clear();
        super.fireTableRowsDeleted(0, size);
    }
}

